/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.client.tsa.service;

import com.whatsapp.tws2.client.tsa.TsaApiService;
import com.whatsapp.tws2.client.tsa.models.AgentInboxResponse;
import com.whatsapp.tws2.client.tsa.models.DateTimeResponseDTO;
import com.whatsapp.tws2.client.tsa.models.ResponseMessageEvent;
import com.whatsapp.tws2.client.tsa.models.Schedule;
import com.whatsapp.tws2.client.tsa.models.TSAScheduleModel;
import com.whatsapp.tws2.data.tsa.RequestMessageModel;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class TsaApiServiceImpl
implements TsaApiService {
    private static final Logger log = LoggerFactory.getLogger(TsaApiServiceImpl.class);
    private final WebClient.Builder webClient;
    private final Environment env;

    public Mono<ResponseMessageEvent> sendMesssageToAsesor(RequestMessageModel data, String callbackId) {
        log.info("Sending message to THINK SERVICE AGENT");
        String token = this.env.getProperty("tsa.api.token");
        String headerName = this.env.getProperty("tsa.api.header");
        data.setCallbackUrl(this.env.getProperty("tsa.api.callback.url"));
        String API_URL = this.env.getProperty("tsa.api.url.messages").replace("{channel}", callbackId);
        log.info(API_URL);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(headerName, token);
        log.info("CONNECTING TO TSA -> URL: {} | BODY: {}", (Object)API_URL, (Object)data);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(API_URL, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).bodyValue((Object)data).retrieve().bodyToMono(ResponseMessageEvent.class).flatMap(response -> {
            log.info("response webhook {}", response);
            return Mono.just((Object)response);
        });
    }

    public Mono<String> closeConvesation(String identifier) {
        log.info("Closing conversation");
        String accountId = this.env.getProperty("tsa.api.accountid");
        String token = this.env.getProperty("tsa.api.token");
        String headerName = this.env.getProperty("tsa.api.header");
        String API_URL = this.env.getProperty("tsa.api.close.conversation.url").replace("{identifier}", identifier).replace("{accountId}", accountId);
        log.info(API_URL);
        HttpHeaders headers = new HttpHeaders();
        headers.add(headerName, token);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().put().uri(API_URL, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).retrieve().bodyToMono(String.class).flatMap(response -> {
            log.info("response webhook close event {}", response);
            return Mono.just((Object)response);
        });
    }

    public Mono<List<Schedule>> getScheduleByTSA(DateTimeResponseDTO dateTimeResponseDTO) {
        log.info("Sending request to TSA...");
        String accountId = this.env.getProperty("tsa.api.accountid");
        String token = this.env.getProperty("tsa.api.token");
        String headerName = this.env.getProperty("tsa.api.header");
        String API_URL = this.env.getProperty("tsa.api.report.time.response.url");
        HttpHeaders headers = new HttpHeaders();
        headers.add(headerName, token);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(API_URL + "/" + accountId, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).bodyValue((Object)dateTimeResponseDTO).retrieve().bodyToFlux(Schedule.class).collectList().doOnNext(schedules -> log.info("Received {} schedules from TSA", (Object)schedules.size())).doOnError(error -> log.error("Error while calling TSA API: {}", (Object)error.getMessage()));
    }

    public Mono<String> saveScheduleByTSA(TSAScheduleModel tsaScheduleModel) {
        log.info("Sending request to TSA...");
        String token = this.env.getProperty("tsa.api.token");
        String headerName = this.env.getProperty("tsa.api.header");
        String API_URL = this.env.getProperty("tsa.api.schedules.url");
        log.info("TSA URL: {}", (Object)API_URL);
        HttpHeaders headers = new HttpHeaders();
        headers.add(headerName, token);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(API_URL, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).bodyValue((Object)tsaScheduleModel).retrieve().bodyToMono(String.class).doOnNext(response -> log.info("TSA response: {}", response)).doOnError(error -> log.error("Error while calling TSA API: {}", (Object)error.getMessage()));
    }

    public Mono<Object> getScheduleByTSAData() {
        log.info("Sending request to TSA...");
        String account = this.env.getProperty("tsa.api.accountid");
        String token = this.env.getProperty("tsa.api.token");
        String headerName = this.env.getProperty("tsa.api.header");
        String API_URL = this.env.getProperty("tsa.api.schedules.url");
        log.info("TSA URL: {}", (Object)API_URL);
        HttpHeaders headers = new HttpHeaders();
        headers.add(headerName, token);
        return this.webClient.build().get().uri(API_URL + "/" + account, new Object[0]).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers)).retrieve().bodyToMono(Object.class).doOnNext(response -> log.info("TSA response: {}", response)).doOnError(error -> log.error("Error while calling TSA API: {}", (Object)error.getMessage()));
    }

    public Mono<List<AgentInboxResponse.AgentInbox>> getAllAgentByInboxByTSAData() {
        log.info("Sending request to TSA...");
        String accountId = this.env.getProperty("tsa.api.accountid");
        String token = this.env.getProperty("tsa.api.token");
        String headerName = this.env.getProperty("tsa.api.header");
        String API_URL = this.env.getProperty("tsa.api.agent.inbox.url");
        HttpHeaders headers = new HttpHeaders();
        headers.add(headerName, token);
        return this.webClient.build().get().uri(API_URL + "/" + accountId, new Object[0]).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers)).retrieve().bodyToMono(AgentInboxResponse.class).map(AgentInboxResponse::getPayload).doOnNext(schedules -> log.info("Received {} schedules from TSA", (Object)schedules.size())).doOnError(error -> log.error("Error while calling TSA API: {}", (Object)error.getMessage()));
    }

    public TsaApiServiceImpl(WebClient.Builder webClient, Environment env) {
        this.webClient = webClient;
        this.env = env;
    }
}

