/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.client.hiper.service.impl;

import com.whatsapp.tws2.client.hiper.service.HiperApiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class HiperApiServiceImpl
implements HiperApiService {
    private static final Logger log = LoggerFactory.getLogger(HiperApiServiceImpl.class);
    private final WebClient.Builder webClient;
    private final Environment env;

    public Mono<String> closeConversationOnHiperPbx(String roomId) {
        log.warn("CERRANDO LA CONVERSACION DE HIPER");
        String API_HIPER_TOKEN = this.env.getProperty("hiper.api.token");
        String apiCloseConversation = this.env.getProperty("hiper.api.url.close-conversation").replace("{room_id}", roomId);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().put().uri(apiCloseConversation, new Object[0])).header("Authorization", new String[]{"Bearer " + API_HIPER_TOKEN})).retrieve().bodyToMono(String.class).onErrorResume(e -> {
            log.error("Error closing conversation on Hiper PBX: {}", (Object)e.getMessage());
            return Mono.empty();
        });
    }

    public HiperApiServiceImpl(WebClient.Builder webClient, Environment env) {
        this.webClient = webClient;
        this.env = env;
    }
}

