/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.client.fileStorage;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.whatsapp.tws2.client.fileStorage.FileService;
import com.whatsapp.tws2.client.fileStorage.FileUploadRequest;
import com.whatsapp.tws2.client.fileStorage.FileUploadResponse;
import com.whatsapp.tws2.client.lhia.service.ApiLhiaService;
import com.whatsapp.tws2.data.TokenKeyCloakModel;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class FileServiceImpl
implements FileService {
    private static final Logger log = LoggerFactory.getLogger(FileServiceImpl.class);
    private final WebClient.Builder webClient;
    private final Environment env;
    private final ApiLhiaService apiToken;

    public Mono<String> getUrlFileStorage(String urlFileMeta) {
        return this.getFileUploadRequest(urlFileMeta).flatMap(fileUploadRequest -> {
            try {
                ObjectMapper mapper = new ObjectMapper();
                String json = mapper.writeValueAsString(fileUploadRequest);
                if (fileUploadRequest.getBase64() != null && !fileUploadRequest.getBase64().isEmpty()) {
                    // empty if block
                }
            }
            catch (JsonProcessingException e) {
                log.error("Error convirtiendo fileUploadRequest a JSON", (Throwable)e);
            }
            String urlApi = this.env.getProperty("url.api.file");
            return this.apiToken.getToken().map(TokenKeyCloakModel::getAccessToken).flatMap(token -> ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(urlApi, new Object[0])).headers(headers -> {
                headers.setContentType(MediaType.APPLICATION_JSON);
                headers.setBearerAuth(token);
            })).bodyValue(fileUploadRequest).retrieve().bodyToMono(FileUploadResponse.class).map(response -> {
                String path = response.getPayload().getPath();
                log.info("Archivo guardado en storage: {}", (Object)path);
                return path;
            }).onErrorResume(e -> {
                log.error("Error guardando archivo en storage", e);
                return Mono.empty();
            }));
        }).onErrorResume(e -> {
            log.error("Error obteniendo archivo para upload desde URL: {}", (Object)urlFileMeta, e);
            return Mono.empty();
        });
    }

    public Mono<FileUploadRequest> getFileUploadRequest(String urlImage) {
        String whatsappToken = this.env.getProperty("whatsapp.token");
        return this.webClient.build().get().uri(urlImage, new Object[0]).headers(headers -> headers.setBearerAuth(whatsappToken)).exchangeToMono(response -> {
            MediaType mediaType = response.headers().contentType().orElse(MediaType.APPLICATION_OCTET_STREAM);
            return response.bodyToMono(byte[].class).map(bytes -> {
                String base64 = Base64.getEncoder().encodeToString((byte[])bytes);
                String extension = mediaType.getSubtype();
                return new FileUploadRequest(base64, extension, "ASESOR");
            });
        }).onErrorResume(e -> {
            log.error("Error descargando archivo desde URL: {}", (Object)urlImage, e);
            return Mono.empty();
        });
    }

    public FileServiceImpl(WebClient.Builder webClient, Environment env, ApiLhiaService apiToken) {
        this.webClient = webClient;
        this.env = env;
        this.apiToken = apiToken;
    }
}

