/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.client.campanas;

import com.whatsapp.tws2.client.campanas.models.CampanasApiConfiguration;
import com.whatsapp.tws2.client.campanas.service.ApiCampanasService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class ApiCampanas
implements ApiCampanasService {
    private static final Logger log = LoggerFactory.getLogger(ApiCampanas.class);
    private final WebClient.Builder webClient;
    private final CampanasApiConfiguration campanasApiConfiguration;

    public Mono<Void> notifyStatusesMessages(Object payload) {
        log.info("Notificando actualizacion de estado");
        String apiToken = this.campanasApiConfiguration.getApiKey();
        String WHATSAPP_API_URL = this.campanasApiConfiguration.getNotificacion();
        log.warn(payload.toString());
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(WHATSAPP_API_URL, new Object[0])).header(this.campanasApiConfiguration.getHeaderApikey(), new String[]{apiToken})).contentType(MediaType.APPLICATION_JSON).body(BodyInserters.fromValue((Object)payload)).retrieve().bodyToMono(Void.class).doOnNext(response -> log.info("Message status notified: {}", response)).onErrorResume(err -> {
            log.error("ERROR NOTIFING {}", (Object)err.getMessage());
            return Mono.empty();
        });
    }

    public ApiCampanas(WebClient.Builder webClient, CampanasApiConfiguration campanasApiConfiguration) {
        this.webClient = webClient;
        this.campanasApiConfiguration = campanasApiConfiguration;
    }
}

