/*
 * Decompiled with CFR 0.152.
 */
package com.hawa.utils;

import com.hawa.logic.data.ConversacionUsuario;
import java.text.Normalizer;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.json.JSONArray;
import org.json.JSONObject;

public class UtilLhia {
    private Logger log = Logger.getLogger(UtilLhia.class.getName());

    public void mostrarLista(List<ConversacionUsuario> lstConversation) {
        this.log.info("------------------------------------------------------------------------");
        int i = 0;
        while (i < lstConversation.size()) {
            this.log.info("rol:" + lstConversation.get(i).getRole());
            this.log.info("mensaje:" + lstConversation.get(i).getContent());
            this.log.info("------------------------------------------------------------------------");
            ++i;
        }
        this.log.info("------------------------------------------------------------------------");
    }

    public String obtenerUltimaRespuesta(List<ConversacionUsuario> lstConversation) {
        String resp = "";
        int i = lstConversation.size() - 1;
        while (i > 0) {
            if (lstConversation.get(i).getRole().equals("assistant")) {
                resp = lstConversation.get(i).getContent();
                break;
            }
            --i;
        }
        return resp;
    }

    public static String parseEmbedding(String response) {
        JSONObject jsonObject = new JSONObject(response);
        JSONArray jsonArray = jsonObject.getJSONArray("embedding");
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        while (i < jsonArray.length()) {
            stringBuilder.append(jsonArray.getDouble(i));
            if (i != jsonArray.length() - 1) {
                stringBuilder.append(",");
            }
            ++i;
        }
        return stringBuilder.toString();
    }

    public double cosineSimilarity(String embedding1, String embedding2) {
        double[] arr1 = Stream.of(embedding1.split(",")).mapToDouble(Double::parseDouble).toArray();
        double[] arr2 = Stream.of(embedding2.split(",")).mapToDouble(Double::parseDouble).toArray();
        double dotProduct = 0.0;
        double norm1 = 0.0;
        double norm2 = 0.0;
        int i = 0;
        while (i < arr1.length) {
            dotProduct += arr1[i] * arr2[i];
            norm1 += Math.pow(arr1[i], 2.0);
            norm2 += Math.pow(arr2[i], 2.0);
            ++i;
        }
        if (norm1 == 0.0 || norm2 == 0.0) {
            return 0.0;
        }
        return dotProduct / (Math.sqrt(norm1) * Math.sqrt(norm2));
    }

    public static LocalDateTime fechaEcuador() {
        ZoneId zonaEcuador = ZoneId.of("America/Guayaquil");
        return LocalDateTime.now(zonaEcuador);
    }

    public static String quitarTildes(String texto) {
        String textoNormalizado = Normalizer.normalize(texto, Normalizer.Form.NFD);
        String textoSinTildes = textoNormalizado.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "");
        textoSinTildes = textoSinTildes.replaceAll("\n", " ");
        return textoSinTildes;
    }
}

