/*
 * Decompiled with CFR 0.152.
 */
package com.hawa.utils;

import com.hawa.exceptions.CustomException;
import org.springframework.http.HttpStatus;

public class ApiResponse<T> {
    private int statusCode;
    private boolean success;
    private boolean hasChildren;
    private String message;
    private T data;

    public ApiResponse(int statusCode, boolean success, boolean hasChildren, String message, T data) {
        this.statusCode = statusCode;
        this.success = success;
        this.hasChildren = hasChildren;
        this.message = message;
        this.data = data;
    }

    public static <T> ApiResponse<T> ok(T data, boolean hasChildren) {
        return new ApiResponse(200, true, hasChildren, "Operaci\u00f3n exitosa", data);
    }

    public static <T> ApiResponse<T> error(int statusCode, String message) {
        return new ApiResponse(statusCode, false, false, message, null);
    }

    public static <T> ApiResponse<T> customException(HttpStatus httpStatus, String message) {
        throw new CustomException(message, httpStatus);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public boolean isHasChildren() {
        return this.hasChildren;
    }

    public void setHasChildren(boolean hasChildren) {
        this.hasChildren = hasChildren;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return (T)this.data;
    }

    public void setData(T data) {
        this.data = data;
    }
}

