/*
 * Decompiled with CFR 0.152.
 */
package com.hawa.logic.service.impl;

import com.hawa.logic.model.Conversacion;
import com.hawa.logic.model.ConversacionDetalle;
import com.hawa.logic.repository.ConversacionDAO;
import com.hawa.logic.repository.ConversacionDetalleDAO;
import com.hawa.logic.service.ConversacionService;
import com.hawa.utils.UtilLhia;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConversacionServiceImpl
implements ConversacionService {
    @Autowired
    private ConversacionDAO conversacionDAO;
    @Autowired
    private ConversacionDetalleDAO conversacionDetalleDAO;

    public void guardarConversacion(String identificador, String usuario, String rol, String mensaje, double score, int prompts, String pregunta, String textSystem) {
        if (this.conversacionDAO.existsByIdentificador(identificador)) {
            if (!rol.isEmpty()) {
                ConversacionDetalle conversacion_detalle = new ConversacionDetalle();
                conversacion_detalle.setRol(rol);
                conversacion_detalle.setMensaje(mensaje);
                conversacion_detalle.setScore(score);
                conversacion_detalle.setTokens((long)prompts);
                conversacion_detalle.setConversacion((Conversacion)this.conversacionDAO.findByIdentificador(identificador).get());
                conversacion_detalle.setFecha(UtilLhia.fechaEcuador());
                conversacion_detalle.setPregunta(pregunta);
                this.conversacionDetalleDAO.save((Object)conversacion_detalle);
            }
        } else {
            Conversacion nueva_conversacion = new Conversacion();
            ConversacionDetalle conversacion_detalle = new ConversacionDetalle();
            nueva_conversacion.setUsuario(usuario);
            nueva_conversacion.setIdentificador(identificador);
            nueva_conversacion.setFecha(UtilLhia.fechaEcuador());
            Conversacion aux = (Conversacion)this.conversacionDAO.save((Object)nueva_conversacion);
            conversacion_detalle.setRol("system");
            conversacion_detalle.setScore(0.0);
            conversacion_detalle.setMensaje(textSystem);
            conversacion_detalle.setTokens(0L);
            conversacion_detalle.setConversacion(aux);
            conversacion_detalle.setFecha(UtilLhia.fechaEcuador());
            conversacion_detalle.setPregunta("");
            this.conversacionDetalleDAO.save((Object)conversacion_detalle);
        }
    }
}

