/*
 * Decompiled with CFR 0.152.
 */
package com.hawa.logic.controller;

import com.hawa.logic.data.ClienteConsumo;
import com.hawa.logic.data.RespuestaRobot;
import com.hawa.logic.service.BaseService;
import com.hawa.logic.service.SeccionDocumentoService;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"serinco"})
public class ProductController {
    @Autowired
    private BaseService serincoRepository;
    @Autowired
    private SeccionDocumentoService seccionDocumentoService;

    @GetMapping(value={"/anonimo"})
    public String saludo1() {
        return "Hola anonimo";
    }

    @GetMapping(value={"/admin"})
    public String saludo2() {
        return "Hola admin";
    }

    @GetMapping(value={"/user"})
    public String saludo3() {
        return "Hola user";
    }

    @PostMapping(value={"/questionV2"}, consumes={"application/json"})
    @CrossOrigin
    @PreAuthorize(value="hasRole('user')")
    public RespuestaRobot getProduct(@RequestBody ClienteConsumo cliente) {
        RespuestaRobot robot = new RespuestaRobot();
        String answer = this.serincoRepository.findProductsByQuestion(cliente.getQuestion(), cliente.getDescripcion(), cliente.getIdentificador(), cliente.getUsuario());
        robot.setRespuesta(answer);
        return robot;
    }

    @GetMapping(value={"/generaEmb"})
    @CrossOrigin
    public void generaEmb() {
        this.seccionDocumentoService.generateEmbeddingsForSections();
    }

    @GetMapping(value={"/generaNumTokens"})
    @CrossOrigin
    public void generaNumTokens() {
        this.serincoRepository.generateNumTokens();
    }

    @PostMapping(value={"/lista/conversacion/tokens"}, produces={"application/json"})
    public int obtenerTokens(@RequestParam LocalDateTime fecha1, LocalDateTime fecha2) {
        return this.serincoRepository.obtenerTokens(fecha1, fecha2);
    }
}

