/*
 * Decompiled with CFR 0.152.
 */
package com.hawa.interceptors;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
public class AuditingInterceptor
implements HandlerInterceptor {
    private static final Logger log = Logger.getLogger(AuditingInterceptor.class.getName());

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        System.out.println("Pre Handle method is Calling");
        log.info(String.valueOf(request.getMethod()) + request.getRequestURI());
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        System.out.println("Post Handle method is Calling");
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        System.out.println("Request and Response is completed " + response.getStatus());
        if (ex != null || response.getStatus() != 200 || response.getStatus() != 201) {
            log.log(Level.INFO, "Petici\u00f3n completada exitosamente: {} {}, Estado: {}" + request.getMethod() + request.getRequestURI(), response.getStatus());
        } else {
            log.log(Level.SEVERE, "Petici\u00f3n completada con error: {} {}" + request.getMethod() + request.getRequestURI(), ex);
        }
    }
}

