/*
 * Decompiled with CFR 0.152.
 */
package com.hawa.auth;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hawa.utils.ApiResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;

public class CustomAuthenticationEntryPoint
implements AuthenticationEntryPoint {
    private static final Logger log = Logger.getLogger(CustomAuthenticationEntryPoint.class.getName());
    private final ObjectMapper objectMapper = new ObjectMapper();

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException {
        log.log(Level.SEVERE, "Unauthorized error: " + authException.getMessage());
        ApiResponse apiResponse = new ApiResponse(HttpStatus.UNAUTHORIZED.value(), false, false, "Unauthorized", null);
        String jsonResponse = this.objectMapper.writeValueAsString((Object)apiResponse);
        response.setContentType("application/json");
        response.setStatus(401);
        response.getOutputStream().write(jsonResponse.getBytes());
    }
}

