/*
 * Decompiled with CFR 0.152.
 */
package com.tcloud.utils;

import com.tcloud.logic.entity.request.TRequestInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class RequestUtils {
    private static final Logger log = LoggerFactory.getLogger(RequestUtils.class);

    public Map<String, Object> getParamsFromRequest(HttpServletRequest request) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        try {
            String ipAddress = request.getHeader("X-Forwarded-For");
            if (ipAddress == null || ipAddress.isEmpty()) {
                ipAddress = request.getRemoteAddr();
            }
            params.put("method", request.getMethod());
            params.put("uri", request.getRequestURI());
            params.put("remoteAddress", ipAddress);
            params.put("localIp", request.getLocalAddr());
            params.put("localName", request.getLocalName());
            params.put("originNavigator", RequestUtils.getNavegador((HttpServletRequest)request));
            String userAgent = request.getHeader("User-Agent");
            if (userAgent != null) {
                if (userAgent.toLowerCase().contains("mobi")) {
                    params.put("typeDevice", "Mobile");
                } else {
                    params.put("typeDevice", "Desktop or Laptop");
                }
            }
        }
        catch (Exception e) {
            log.warn("error, {}", (Object)e.getMessage());
        }
        return params;
    }

    public void saveInfoAudit(HttpServletRequest request, HttpServletResponse response) {
        try {
            long startTime = (Long)request.getAttribute("startTime");
            long endTime = System.currentTimeMillis();
            long executionTime = endTime - startTime;
            Integer status = response.getStatus();
            Map params = this.getParamsFromRequest(request);
            TRequestInfo info = new TRequestInfo();
            info.setMethod(this.validarNulos(params.get("method")));
            info.setLocalIp(this.validarNulos(params.get("localIp")));
            info.setUri(this.validarNulos(params.get("uri")));
            info.setRemoteAddress(this.validarNulos(params.get("remoteAddress")));
            info.setLocalName(this.validarNulos(params.get("localName")));
            info.setOriginNavigator(this.validarNulos(params.get("originNavigator")));
            info.setTypeDevice(this.validarNulos(params.get("typeDevice")));
            info.setExecutionTime(Long.valueOf(executionTime));
            info.setStatus(status);
            info.setCreatedAt(LocalDateTime.now());
        }
        catch (Exception e) {
            log.error("Error al guardar la informaci\u00f3n de auditor\u00eda", (Throwable)e);
        }
    }

    private String validarNulos(Object key) {
        if (key == null) {
            return "";
        }
        return key.toString();
    }

    private static String getNavegador(HttpServletRequest request) {
        try {
            String userAgent = request.getHeader("User-Agent");
            if (userAgent == null) {
                return "No User-Agent header found.";
            }
            String browserDetails = "Unknown Browser";
            String user = userAgent.toLowerCase();
            if (user.contains("msie")) {
                browserDetails = "Internet Explorer";
            } else if (user.contains("trident")) {
                browserDetails = "Internet Explorer 11";
            } else if (user.contains("edge")) {
                browserDetails = "Microsoft Edge";
            } else if (user.contains("chrome")) {
                browserDetails = "Google Chrome";
            } else if (user.contains("safari") && user.contains("version")) {
                browserDetails = "Safari";
            } else if (user.contains("firefox")) {
                browserDetails = "Mozilla Firefox";
            } else if (user.contains("opera") || user.contains("opr")) {
                browserDetails = "Opera";
            }
            return "User-Agent: " + userAgent + "\nBrowser: " + browserDetails;
        }
        catch (Exception e) {
            return "";
        }
    }
}

