/*
 * Decompiled with CFR 0.152.
 */
package com.tcloud.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.tcloud.exceptions.CustomException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.HttpStatus;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ApiResponse<T> {
    private int status;
    private Boolean success;
    private Boolean hasChildren;
    private String message;
    private Map<String, String> messages;
    private T payload;

    public ApiResponse(int statusCode, boolean success, boolean hasChildren, String message, T data) {
        this.status = statusCode;
        this.success = success;
        this.hasChildren = hasChildren;
        this.message = message;
        this.payload = data;
    }

    public ApiResponse(int statusCode, T data) {
        this.status = statusCode;
        this.payload = data;
    }

    public ApiResponse(int statusCode, Map<String, String> messages) {
        this.status = statusCode;
        this.success = false;
        this.messages = messages;
    }

    public static <T> ApiResponse<T> ok(T data, boolean hasChildren) {
        return new ApiResponse(200, true, hasChildren, "Operaci\u00f3n exitosa", data);
    }

    public static <T> ApiResponse<T> ok(int status, T data) {
        return new ApiResponse(status, data);
    }

    public static <T> ApiResponse<T> error(int statusCode, Map<String, String> messages) {
        return new ApiResponse(statusCode, messages);
    }

    public static <T> ApiResponse<T> error(int statusCode, String message) {
        HashMap<String, String> messages = new HashMap<String, String>();
        messages.put("error", message);
        return new ApiResponse(statusCode, messages);
    }

    public static <T> ApiResponse<T> customException(HttpStatus httpStatus, String message) {
        throw new CustomException(message, httpStatus);
    }

    public int getStatus() {
        return this.status;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public Boolean getHasChildren() {
        return this.hasChildren;
    }

    public String getMessage() {
        return this.message;
    }

    public Map<String, String> getMessages() {
        return this.messages;
    }

    public T getPayload() {
        return (T)this.payload;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public void setHasChildren(Boolean hasChildren) {
        this.hasChildren = hasChildren;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setMessages(Map<String, String> messages) {
        this.messages = messages;
    }

    public void setPayload(T payload) {
        this.payload = payload;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiResponse)) {
            return false;
        }
        ApiResponse other = (ApiResponse)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        Boolean this$success = this.getSuccess();
        Boolean other$success = other.getSuccess();
        if (this$success == null ? other$success != null : !((Object)this$success).equals(other$success)) {
            return false;
        }
        Boolean this$hasChildren = this.getHasChildren();
        Boolean other$hasChildren = other.getHasChildren();
        if (this$hasChildren == null ? other$hasChildren != null : !((Object)this$hasChildren).equals(other$hasChildren)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Map this$messages = this.getMessages();
        Map other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        Object this$payload = this.getPayload();
        Object other$payload = other.getPayload();
        return !(this$payload == null ? other$payload != null : !this$payload.equals(other$payload));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApiResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStatus();
        Boolean $success = this.getSuccess();
        result = result * 59 + ($success == null ? 43 : ((Object)$success).hashCode());
        Boolean $hasChildren = this.getHasChildren();
        result = result * 59 + ($hasChildren == null ? 43 : ((Object)$hasChildren).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Map $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        Object $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
        return result;
    }

    public String toString() {
        return "ApiResponse(status=" + this.getStatus() + ", success=" + this.getSuccess() + ", hasChildren=" + this.getHasChildren() + ", message=" + this.getMessage() + ", messages=" + this.getMessages() + ", payload=" + this.getPayload() + ")";
    }

    public ApiResponse() {
    }

    public ApiResponse(int status, Boolean success, Boolean hasChildren, String message, Map<String, String> messages, T payload) {
        this.status = status;
        this.success = success;
        this.hasChildren = hasChildren;
        this.message = message;
        this.messages = messages;
        this.payload = payload;
    }
}

