/*
 * Decompiled with CFR 0.152.
 */
package com.tcloud.logic.service.impl;

import com.knuddels.jtokkit.Encodings;
import com.knuddels.jtokkit.api.Encoding;
import com.knuddels.jtokkit.api.EncodingRegistry;
import com.knuddels.jtokkit.api.ModelType;
import com.tcloud.logic.entity.ConversacionDetalle;
import com.tcloud.logic.entity.ConversacionUsuario;
import com.tcloud.logic.entity.SeccionDocumento;
import com.tcloud.logic.entity.dto.RespuestaRobotDTO;
import com.tcloud.logic.service.ImageRecognitionService;
import com.tcloud.logic.service.QuestionMetricService;
import com.tcloud.logic.service.SeccionDocumentoService;
import com.tcloud.logic.service.impl.AuthenticationServiceImpl;
import com.tcloud.logic.service.impl.ChatApiServiceImpl;
import com.tcloud.repository.ConversacionDetalleDAO;
import com.tcloud.repository.DocumentFileDAO;
import com.tcloud.repository.EmpresaDAO;
import com.tcloud.utils.PromptUtils;
import com.tcloud.utils.UtilLhia;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class QuestionMetricsServiceImpl
implements QuestionMetricService {
    private static final Logger log = LoggerFactory.getLogger(QuestionMetricsServiceImpl.class);
    @Autowired
    private AuthenticationServiceImpl authService;
    @Autowired
    private ConversacionDetalleDAO conversacionDetalleDAO;
    @Autowired
    private EmpresaDAO empresaDAO;
    @Autowired
    private ChatApiServiceImpl chatApiService;
    @Autowired
    private ImageRecognitionService imageReecongService;
    @Autowired
    private SeccionDocumentoService seccionDocService;
    @Autowired
    private DocumentFileDAO documentFileDAO;
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${back.python.path}")
    private String pythonUrl;
    @Value(value="${back.spring.local}")
    private String lhiaDomainUrl;
    private EncodingRegistry registry = Encodings.newLazyEncodingRegistry();
    private Encoding encoding = this.registry.getEncodingForModel(ModelType.CUSHMAN_CODEX);
    private String textSystem = "";

    public RespuestaRobotDTO findDocumentsByQuestion(String question, String descripcion, String usuario, String identificador) {
        ArrayList<ConversacionUsuario> conversacionUsuario = new ArrayList<ConversacionUsuario>();
        this.textSystem = PromptUtils.getPromptExpert();
        conversacionUsuario.add(0, new ConversacionUsuario("system", this.textSystem));
        List conversacion = this.conversacionDetalleDAO.obtenerConversacion(identificador);
        conversacion.sort((objeto1, objeto2) -> Long.compare(objeto1.getIdConversacionDetalle(), objeto2.getIdConversacionDetalle()));
        for (ConversacionDetalle c : conversacion) {
            conversacionUsuario.add(new ConversacionUsuario(c.getRol(), c.getMensaje()));
        }
        String promptPrincipal = question.isEmpty() ? "usuario: hola" : question.toUpperCase().replaceAll("\n", "") + " ";
        String embedding = this.seccionDocService.generateEmbedding(UtilLhia.quitarTildes((String)promptPrincipal.toUpperCase()).replace("\u00bf", "").replace("?", ""));
        List secciones = this.seccionDocService.getPromptsByRole(descripcion);
        double maxSimilarity = -1.0;
        Object prompt = "";
        double scoreFinal = 0.0;
        ArrayList<SeccionDocumento> masSimilar = new ArrayList<SeccionDocumento>();
        for (SeccionDocumento seccion : secciones) {
            double similarity = UtilLhia.cosineSimilarity((String)embedding, (String)seccion.getEmbedding());
            if (!(similarity > maxSimilarity)) continue;
            maxSimilarity = similarity;
            seccion.setScore(maxSimilarity);
            if (!(maxSimilarity >= 0.5)) continue;
            masSimilar.add(seccion);
        }
        if (masSimilar.isEmpty()) {
            prompt = "contexto: no se encontr\u00f3 la informaci\u00f3n\n";
        } else {
            masSimilar.sort((p1, p2) -> Double.compare(p2.getScore(), p1.getScore()));
            prompt = "contexto: el resultado de " + ((SeccionDocumento)masSimilar.get(0)).getDocumento().getNombre() + " es el siguiente:\n";
            for (SeccionDocumento seccion : masSimilar) {
                prompt = (String)prompt + seccion.getTexto() + "\n\n";
            }
            scoreFinal = ((SeccionDocumento)masSimilar.get(0)).getScore();
        }
        String promptCompleto = ((String)prompt).concat("pregunta: " + promptPrincipal);
        conversacionUsuario.add(new ConversacionUsuario("user", promptCompleto));
        String answer = this.chatApiService.respondePreguntasV2(conversacionUsuario);
        if (answer.contains("incidente") || answer.contains("requerimiento")) {
            if (answer.contains("incidente")) {
                answer = "Para registrar un incidente, necesito la descripci\u00f3n corta y la descripci\u00f3n detallada.";
            } else if (answer.contains("requerimiento")) {
                answer = "Para registrar un requerimiento, necesito la descripci\u00f3n corta y la descripci\u00f3n detallada.";
            }
        } else {
            answer = "No pude determinar el tipo de solicitud. Por favor, proporciona m\u00e1s informaci\u00f3n.";
        }
        if (!answer.contains("descripci\u00f3n corta") || answer.contains("descripci\u00f3n detallada")) {
            // empty if block
        }
        this.chatApiService.guardarConversacion(identificador, usuario, descripcion, question, "", promptCompleto, scoreFinal, 0, this.textSystem);
        RespuestaRobotDTO robot = new RespuestaRobotDTO();
        robot.setRespuesta(answer);
        return robot;
    }
}

