/*
 * Decompiled with CFR 0.152.
 */
package com.tcloud.logic.controller;

import com.tcloud.logic.entity.ClienteConsumo;
import com.tcloud.logic.entity.dto.RespuestaRobotDTO;
import com.tcloud.logic.service.SeccionDocumentoService;
import com.tcloud.logic.service.impl.QuestionMetricsServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"qna"})
@CrossOrigin
public class QuestionController {
    private static final Logger log = LoggerFactory.getLogger(QuestionController.class);
    private final SeccionDocumentoService seccionDocService;
    private final QuestionMetricsServiceImpl questionService;

    @PostMapping(value={"/question"})
    @PreAuthorize(value="hasRole('user')")
    public RespuestaRobotDTO getProduct(@RequestBody ClienteConsumo cliente) {
        RespuestaRobotDTO robot = new RespuestaRobotDTO();
        robot = this.questionService.findDocumentsByQuestion(cliente.getQuestion(), cliente.getDescripcion(), cliente.getUsuario(), cliente.getIdentificador());
        return robot;
    }

    @GetMapping(value={"/generaEmb"})
    @PreAuthorize(value="hasRole('user')")
    public void generaEmb() {
        this.seccionDocService.generateEmbeddingsForSections();
    }

    public QuestionController(SeccionDocumentoService seccionDocService, QuestionMetricsServiceImpl questionService) {
        this.seccionDocService = seccionDocService;
        this.questionService = questionService;
    }
}

