/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.go.util;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

/*
 * Exception performing whole class analysis ignored.
 */
public class ImageGrayUtil {
    public static byte[] convertirAGrisYMediana(byte[] entrada, int windowSize) throws IOException {
        if (windowSize % 2 == 0 || windowSize < 3) {
            throw new IllegalArgumentException("windowSize debe ser impar y >= 3 (p.ej. 3, 5, 7).");
        }
        BufferedImage original = ImageIO.read(new ByteArrayInputStream(entrada));
        if (original == null) {
            throw new IOException("No se pudo leer la imagen.");
        }
        BufferedImage gris = new BufferedImage(original.getWidth(), original.getHeight(), 10);
        ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        op.filter(original, gris);
        BufferedImage filtrada = ImageGrayUtil.aplicarMediana((BufferedImage)gris, (int)windowSize);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)filtrada, "png", baos);
        return baos.toByteArray();
    }

    private static BufferedImage aplicarMediana(BufferedImage src, int windowSize) {
        if (src.getType() != 10) {
            throw new IllegalArgumentException("La imagen debe ser TYPE_BYTE_GRAY.");
        }
        int w = src.getWidth();
        int h = src.getHeight();
        int r = windowSize / 2;
        byte[] in = ((DataBufferByte)src.getRaster().getDataBuffer()).getData();
        BufferedImage outImg = new BufferedImage(w, h, 10);
        byte[] out = ((DataBufferByte)outImg.getRaster().getDataBuffer()).getData();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int v;
                int[] hist = new int[256];
                int y0 = Math.max(0, y - r);
                int y1 = Math.min(h - 1, y + r);
                int x0 = Math.max(0, x - r);
                int x1 = Math.min(w - 1, x + r);
                int total = 0;
                for (int yy = y0; yy <= y1; ++yy) {
                    int base = yy * w;
                    for (int xx = x0; xx <= x1; ++xx) {
                        int n = v = in[base + xx] & 0xFF;
                        hist[n] = hist[n] + 1;
                        ++total;
                    }
                }
                int medRank = (total + 1) / 2;
                int acc = 0;
                int median = 0;
                for (v = 0; v < 256; ++v) {
                    if ((acc += hist[v]) < medRank) continue;
                    median = v;
                    break;
                }
                out[y * w + x] = (byte)median;
            }
        }
        return outImg;
    }

    public static byte[] convertirAGris(byte[] entrada) throws IOException {
        BufferedImage original = ImageIO.read(new ByteArrayInputStream(entrada));
        if (original == null) {
            throw new IOException("No se pudo leer la imagen.");
        }
        BufferedImage gris = new BufferedImage(original.getWidth(), original.getHeight(), 10);
        ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        op.filter(original, gris);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)gris, "png", baos);
        return baos.toByteArray();
    }
}

