/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.go.util;

import ec.tws2.back.lhia.go.data.ChequeBankAnversoJSON;
import ec.tws2.back.lhia.go.data.ChequeBankReversoJSON;
import ec.tws2.back.lhia.go.data.EmailVoucher;
import ec.tws2.back.lhia.go.data.FileVoucher;
import ec.tws2.back.lhia.go.data.VoucherJSON;
import ec.tws2.back.lhia.go.dto.ValidVoucherDTO;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public class EmailUtil {
    static String company = "DeGO";

    public static EmailVoucher createEmailVoucherBank(VoucherJSON voucherJSON, String fileBase64, String codeEmail, ValidVoucherDTO validVoucherDTO, List<String> emailList) {
        FileVoucher fileVoucher = new FileVoucher();
        fileVoucher.setFileName(EmailUtil.generateFileName((String)"document", (String)"png"));
        fileVoucher.setFileBase64(fileBase64);
        String subject = "Validaci\u00f3n de Cheque " + company;
        return new EmailVoucher(emailList, true, subject.toUpperCase(), EmailUtil.htmlContentVoucher((VoucherJSON)voucherJSON, (ValidVoucherDTO)validVoucherDTO), codeEmail, Collections.singletonList(fileVoucher));
    }

    public static String htmlContentVoucher(VoucherJSON voucherJSON, ValidVoucherDTO validVoucherDTO) {
        Object additionalMessage = "";
        Object observationSection = "";
        String dateString = voucherJSON.getFecha();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");
        String fechaVencimiento = "";
        try {
            LocalDate chequeDate = LocalDate.parse(dateString, formatter);
            LocalDate currentDate = LocalDate.now();
            LocalDate dueDate = chequeDate.plusDays(20L);
            fechaVencimiento = dueDate.format(formatter);
            long daysDifference = ChronoUnit.DAYS.between(chequeDate, currentDate);
            additionalMessage = daysDifference <= 20L ? "<p><strong>El cheque se encuentra dentro del per\u00edodo de cobro.</strong> Faltan " + (20L - daysDifference) + " d\u00edas para que el cheque venza.</p>" : "<p><strong>El cheque ha superado el per\u00edodo m\u00e1ximo de cobro.</strong> Han pasado " + (daysDifference - 20L) + " d\u00edas desde el vencimiento.</p>";
        }
        catch (Exception e) {
            additionalMessage = "<p><strong>Error:</strong> No se pudo procesar la fecha de emisi\u00f3n del cheque.</p>";
        }
        if (validVoucherDTO.getObservation() != null && !validVoucherDTO.getObservation().isEmpty()) {
            observationSection = "<tr><td style='background-color: #f4f4f4; font-weight: bold;'>Observaci\u00f3n:</td><td>" + validVoucherDTO.getObservation() + "</td></tr>";
        }
        String generalWarning = "<p style='font-weight: bold;'>Nota importante: Todo cheque debe cobrarse como m\u00e1ximo 20 d\u00edas despu\u00e9s de su emisi\u00f3n.</p>";
        return "<!DOCTYPE html><html><head><meta charset='UTF-8'><title>Reporte de Cheque Analizado</title></head><body style='font-family: Arial, sans-serif; background-color: #f4f4f4; margin: 0; padding: 0;'><table align='center' border='0' cellpadding='0' cellspacing='0' width='600' style='background-color: #ffffff; margin: 20px auto; border: 1px solid #ddd;'><tr><td style='padding: 20px; text-align: center; background-color: #0073e6; color: #ffffff;'><h2>Reporte de Cheque Analizado</h2></td></tr><tr><td style='padding: 20px; font-size: 16px; color: #333333;'><p>Estimado usuario,</p><p>Los detalles del cheque analizado son los siguientes:</p><table border='0' cellpadding='8' cellspacing='0' width='100%' style='border: 1px solid #ddd;'><tr><td style='background-color: #f4f4f4; font-weight: bold;'>Nombre del titular:</td><td>" + voucherJSON.getNombre() + "</td></tr><tr><td style='background-color: #f4f4f4; font-weight: bold;'>N&uacute;mero del cheque:</td><td>" + voucherJSON.getNumero() + "</td></tr><tr><td style='background-color: #f4f4f4; font-weight: bold;'>Monto:</td><td>" + voucherJSON.getMonto() + " $ </td></tr><tr><td style='background-color: #f4f4f4; font-weight: bold;'>Fecha de emisi&oacute;n:</td><td>" + voucherJSON.getFecha() + "</td></tr><tr><td style='background-color: #f4f4f4; font-weight: bold;'>Fecha de vencimiento:</td><td>" + fechaVencimiento + "</td></tr><tr><td style='background-color: #f4f4f4; font-weight: bold;'>Entidad financiera:</td><td>" + voucherJSON.getEntidadFinanciera() + "</td></tr>" + (String)observationSection + "</table>" + (String)additionalMessage + generalWarning + "<p style='font-size: 14px; color: #555555;'>Este es un mensaje generado autom&aacute;ticamente. Por favor, no responda a este correo.</p></td></tr><tr><td style='text-align: center; padding: 10px; background-color: #f4f4f4; font-size: 12px; color: #777777;'><p>&copy; 2024 " + company + ". Todos los derechos reservados.</p></td></tr></table></body></html>";
    }

    public static String buildChequeMessageReverso(ChequeBankReversoJSON chequeBack) {
        String llenoTexto;
        String ladoTexto;
        String string = chequeBack.getIsBackSide() != null ? (chequeBack.getIsBackSide().booleanValue() ? "S\u00ed (Reverso detectado)" : "No (Es anverso)") : (ladoTexto = "\u26a0\ufe0f No especificado");
        String string2 = chequeBack.getIsBackFilled() != null ? (chequeBack.getIsBackFilled().booleanValue() ? "S\u00ed, tiene datos" : "No, est\u00e1 vac\u00edo") : (llenoTexto = "\u26a0\ufe0f No especificado");
        String selloTexto = chequeBack.getStampsPresent() != null && chequeBack.getStampsPresent() != false ? "S\u00ed (" + (chequeBack.getStampsText() != null ? chequeBack.getStampsText() : "Texto no legible") + ")" : "No";
        String manuscrito = chequeBack.getHandwritingDetected() != null && chequeBack.getHandwritingDetected() != false ? "S\u00ed" : "No";
        return String.format("\ud83d\udcc4 Informaci\u00f3n del reverso del cheque:\n\n\ud83d\udccc \u00bfEs reverso?: %s\n\u270d\ufe0f \u00bfTiene datos llenados?: %s\n\ud83d\udd8b\ufe0f Sellos: %s\n\u2712\ufe0f Escritura manuscrita detectada: %s\n\ud83d\udcca Confianza: %.2f", ladoTexto, llenoTexto, selloTexto, manuscrito, chequeBack.getConfidence() != null ? chequeBack.getConfidence() : 0.0);
    }

    public static String buildChequeMessageAnverso(ChequeBankAnversoJSON cheque) {
        String cruzadoTexto;
        String firmaTexto = cheque.getSignature() != null && cheque.getSignature() != false ? "S\u00ed" : "No";
        String montoNumerico = cheque.getCurrency() + " " + (cheque.getAmount() != null ? cheque.getAmount().setScale(2, RoundingMode.HALF_UP).toString() : "0.00");
        String string = cheque.getIsCrossed() != null ? (cheque.getIsCrossed().booleanValue() ? "S\u00ed " : "No ") : (cruzadoTexto = "\u26a0\ufe0f No especificado");
        String endosoTexto = cheque.getHasNoALaOrden() != null ? (cheque.getHasNoALaOrden().booleanValue() ? "No permitido (NO A LA ORDEN)" : "S\u00ed permitido") : "No especificado";
        return String.format("\ud83d\udcc4 Informaci\u00f3n del anverso del cheque:\n\n\ud83c\udfe6 Banco: %s\n#\ufe0f\u20e3 N\u00famero de cheque: %s\n\ud83d\udcb3 Cuenta: %s\n\ud83d\udc64 Beneficiario: %s\n\ud83d\udcb5 Monto: %s\n\ud83d\udcc5 Fecha: %s\n\ud83d\udccd Lugar: %s\n\u270d\ufe0f Firma: %s\n\u2796 Cruzado: %s\n\ud83d\udd04 Endoso: %s\n", EmailUtil.safe((String)cheque.getBank()), EmailUtil.safe((String)cheque.getCheckNumber()), EmailUtil.safe((String)cheque.getAccountNumber()), EmailUtil.safe((String)cheque.getBeneficiary()), montoNumerico != null ? montoNumerico : "S/D", EmailUtil.safe((String)cheque.getDate()), EmailUtil.safe((String)cheque.getPlace()), EmailUtil.safe((String)firmaTexto), EmailUtil.safe((String)cruzadoTexto), EmailUtil.safe((String)endosoTexto));
    }

    public static String buildChequeEmailTemplateFull(ChequeBankAnversoJSON cheque, ChequeBankReversoJSON back, String imageFrontUrl, String imageBackUrl) {
        String isBackFilledTxt;
        String isBackSideTxt;
        String endosoTexto;
        String cruzadoTexto;
        String frontImageBlock = imageFrontUrl != null ? "<div style='margin:16px 0;text-align:center;'><img src='" + EmailUtil.esc((String)imageFrontUrl) + "' alt='Cheque Anverso' style='max-width:100%;height:auto;border:1px solid #e5e7eb;border-radius:8px;'><div style='font-size:12px;color:#6b7280;margin-top:4px;'>Imagen del Anverso</div></div>" : "";
        String backImageBlock = imageBackUrl != null ? "<div style='margin:16px 0;text-align:center;'><img src='" + EmailUtil.esc((String)imageBackUrl) + "' alt='Cheque Reverso' style='max-width:100%;height:auto;border:1px solid #e5e7eb;border-radius:8px;'><div style='font-size:12px;color:#6b7280;margin-top:4px;'>Imagen del Reverso</div></div>" : "";
        String currency = cheque.getCurrency() != null ? cheque.getCurrency() : "USD";
        String firmaTexto = Boolean.TRUE.equals(cheque.getSignature()) ? "S\u00ed" : "No";
        String montoNumerico = currency + " " + (cheque.getAmount() != null ? cheque.getAmount().setScale(2, RoundingMode.HALF_UP).toString() : "0.00");
        String string = cheque.getIsCrossed() == null ? "No especificado" : (cruzadoTexto = cheque.getIsCrossed() != false ? "S\u00ed" : "No");
        String string2 = cheque.getHasNoALaOrden() == null ? "No especificado" : (endosoTexto = cheque.getHasNoALaOrden() != false ? "No permitido (NO A LA ORDEN)" : "S\u00ed permitido");
        String badgeCruzado = EmailUtil.badge((String)(cruzadoTexto.equals("S\u00ed") ? "success" : (cruzadoTexto.equals("No") ? "muted" : "warn")), (String)("Cruzado: " + cruzadoTexto));
        String badgeEndoso = EmailUtil.badge((String)(endosoTexto.startsWith("No permitido") ? "danger" : (endosoTexto.equals("S\u00ed permitido") ? "success" : "warn")), (String)("Endoso: " + endosoTexto));
        String string3 = back != null && back.getIsBackSide() != null ? (back.getIsBackSide().booleanValue() ? "S\u00ed (Reverso detectado)" : "No (Es anverso)") : (isBackSideTxt = "No especificado");
        String string4 = back != null && back.getIsBackFilled() != null ? (back.getIsBackFilled().booleanValue() ? "S\u00ed, tiene datos" : "No, est\u00e1 vac\u00edo") : (isBackFilledTxt = "No especificado");
        String selloTexto = back != null && Boolean.TRUE.equals(back.getStampsPresent()) ? "S\u00ed" + (String)(back.getStampsText() != null ? " (" + back.getStampsText() + ")" : "") : "No";
        String manuscrito = back != null && Boolean.TRUE.equals(back.getHandwritingDetected()) ? "S\u00ed" : "No";
        String conf = back != null && back.getConfidence() != null ? String.format("%.2f", back.getConfidence()) : "0.00";
        String badgeBackSide = EmailUtil.badge((String)"info", (String)("\u00bfReverso?: " + isBackSideTxt));
        String badgeBackFilled = EmailUtil.badge((String)(isBackFilledTxt.startsWith("S\u00ed") ? "success" : (isBackFilledTxt.startsWith("No") ? "muted" : "warn")), (String)("\u00bfLlenado?: " + isBackFilledTxt));
        return "<!DOCTYPE html><html lang=\"es\"><head>  <meta charset=\"UTF-8\">  <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">  <style>    body{margin:0;padding:24px;background:#f4f6f8;font-family:Arial,Helvetica,sans-serif;color:#2c3e50}    .container{max-width:720px;margin:0 auto;background:#fff;border-radius:12px;box-shadow:0 4px 16px rgba(0,0,0,.08);overflow:hidden}    .header{padding:20px 24px;background:#1f2937;color:#fff}    h1{margin:0;font-size:20px;line-height:1.3}    .section{padding:20px 24px;border-top:1px solid #eef2f7}    .title{margin:0 0 12px 0;font-size:16px}    .badges{margin:8px 0 16px 0}    .badge{display:inline-block;padding:6px 10px;border-radius:999px;font-size:12px;font-weight:bold;margin-right:6px;margin-bottom:6px;color:#fff}    .badge-success{background:#16a34a}    .badge-danger{background:#dc2626}    .badge-info{background:#0ea5e9}    .badge-warn{background:#f59e0b}    .badge-muted{background:#6b7280}    table{width:100%;border-collapse:collapse;background:#fff}    th,td{text-align:left;padding:10px;border-bottom:1px solid #eef2f7;font-size:14px;vertical-align:top}    th{width:34%;color:#4b5563;font-weight:600}    .hint{font-size:12px;color:#6b7280}    .footer{padding:16px 24px;background:#fafbfc;color:#6b7280;font-size:12px;text-align:center}    @media (max-width:600px){th{width:42%} body{padding:12px}}  </style></head><body>  <div class=\"container\">    <div class=\"header\"><h1>Informe de Cheque </h1></div>    <div class=\"section\">      <h2 class=\"title\">Anverso</h2>      <div class=\"badges\">" + badgeCruzado + badgeEndoso + "</div>" + frontImageBlock + "      <table role=\"presentation\" cellspacing=\"0\" cellpadding=\"0\">" + EmailUtil.row((String)"Banco", (String)EmailUtil.safe((String)cheque.getBank())) + EmailUtil.row((String)"N\u00famero de cheque", (String)EmailUtil.safe((String)cheque.getCheckNumber())) + EmailUtil.row((String)"Cuenta", (String)EmailUtil.safe((String)cheque.getAccountNumber())) + EmailUtil.row((String)"Beneficiario", (String)EmailUtil.safe((String)cheque.getBeneficiary())) + EmailUtil.row((String)"Monto", (String)montoNumerico) + EmailUtil.row((String)"Fecha", (String)EmailUtil.safe((String)cheque.getDate())) + EmailUtil.row((String)"Lugar", (String)EmailUtil.safe((String)cheque.getPlace())) + EmailUtil.row((String)"Firma", (String)firmaTexto) + EmailUtil.row((String)"Cruzado", (String)cruzadoTexto) + EmailUtil.row((String)"Endoso", (String)endosoTexto) + "      </table>    </div>    <div class=\"section\">      <h2 class=\"title\">Reverso</h2>      <div class=\"badges\">" + badgeBackSide + badgeBackFilled + "</div>" + backImageBlock + "      <table role=\"presentation\" cellspacing=\"0\" cellpadding=\"0\">" + EmailUtil.row((String)"\u00bfEs reverso?", (String)isBackSideTxt) + EmailUtil.row((String)"\u00bfTiene datos llenados?", (String)isBackFilledTxt) + EmailUtil.row((String)"Sellos", (String)selloTexto) + EmailUtil.row((String)"Escritura manuscrita", (String)manuscrito) + EmailUtil.row((String)"Confianza", (String)conf) + "      </table>    </div>    <div class=\"footer\">      Este correo fue generado autom\u00e1ticamente. Si no esperaba este mensaje, por favor ign\u00f3relo.    </div>  </div></body></html>";
    }

    public static String generateFileName(String prefix, String extension) {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");
        String timestamp = now.format(formatter);
        return prefix + "_" + timestamp + "." + extension;
    }

    public static String row(String k, String v) {
        return "<tr><th>" + EmailUtil.esc((String)k) + "</th><td>" + EmailUtil.esc((String)v) + "</td></tr>";
    }

    public static String safe(String s) {
        return s != null ? EmailUtil.esc((String)s) : "No especificado";
    }

    public static String safeData(String value) {
        return value != null && !value.trim().isEmpty() ? value : "S/D";
    }

    public static String esc(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;");
    }

    public static String badge(String tone, String text) {
        Object cls = "badge ";
        switch (tone) {
            case "success": {
                cls = (String)cls + "badge-success";
                break;
            }
            case "danger": {
                cls = (String)cls + "badge-danger";
                break;
            }
            case "info": {
                cls = (String)cls + "badge-info";
                break;
            }
            case "warn": {
                cls = (String)cls + "badge-warn";
                break;
            }
            default: {
                cls = (String)cls + "badge-muted";
            }
        }
        return "<span class=\"" + (String)cls + "\">" + EmailUtil.esc((String)text) + "</span>";
    }
}

