/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.go.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import ec.tws2.back.lhia.go.data.ChequeBankAnversoJSON;
import ec.tws2.back.lhia.go.data.ChequeBankReversoJSON;
import ec.tws2.back.lhia.go.data.VoucherJSON;
import java.util.Collections;
import java.util.Optional;

public class ConvertJsonUtil {
    public static Optional<ChequeBankAnversoJSON> dataChequeAnversoJSON(String dataChequeBankJSON) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            ChequeBankAnversoJSON dataJSON = (ChequeBankAnversoJSON)objectMapper.readValue(dataChequeBankJSON, ChequeBankAnversoJSON.class);
            if (dataJSON.getSignature() == null) {
                dataJSON.setSignature(Boolean.valueOf(false));
            }
            if (dataJSON.getHasNoALaOrden() == null) {
                dataJSON.setHasNoALaOrden(Boolean.valueOf(false));
            }
            if (dataJSON.getIsCrossed() == null) {
                dataJSON.setIsCrossed(Boolean.valueOf(false));
            }
            return Optional.of(dataJSON);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public static Optional<ChequeBankReversoJSON> dataChequeReversoJSON(String dataChequeBackJSON) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            ChequeBankReversoJSON dataJSON = (ChequeBankReversoJSON)objectMapper.readValue(dataChequeBackJSON, ChequeBankReversoJSON.class);
            if (dataJSON.getIsBackSide() == null) {
                dataJSON.setIsBackSide(Boolean.valueOf(false));
            }
            if (dataJSON.getIsBackFilled() == null) {
                dataJSON.setIsBackFilled(Boolean.valueOf(false));
            }
            if (dataJSON.getEndorsementCount() == null) {
                dataJSON.setEndorsementCount(Integer.valueOf(0));
            }
            if (dataJSON.getFilledSections() == null) {
                dataJSON.setFilledSections(Collections.emptyList());
            }
            if (dataJSON.getDepositor() == null) {
                dataJSON.setDepositor(new ChequeBankReversoJSON.Depositor());
            }
            return Optional.of(dataJSON);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public static VoucherJSON dataVoucherJSON(String dataVoucher) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            VoucherJSON voucherJSON = (VoucherJSON)objectMapper.readValue(dataVoucher, VoucherJSON.class);
            return voucherJSON;
        }
        catch (Exception e) {
            return null;
        }
    }
}

