/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.go.service.impl;

import ec.tws2.back.lhia.go.client.EmailApi;
import ec.tws2.back.lhia.go.client.ImageRecognitionApi;
import ec.tws2.back.lhia.go.client.MetaApi;
import ec.tws2.back.lhia.go.common.enums.StatusTransactions;
import ec.tws2.back.lhia.go.common.transactions.TransactionCustom;
import ec.tws2.back.lhia.go.data.ChequeBankAnversoJSON;
import ec.tws2.back.lhia.go.data.ChequeBankReversoJSON;
import ec.tws2.back.lhia.go.data.EmailVoucher;
import ec.tws2.back.lhia.go.data.FileVoucher;
import ec.tws2.back.lhia.go.data.ResponseResult;
import ec.tws2.back.lhia.go.data.VoucherJSON;
import ec.tws2.back.lhia.go.dto.BankCheckDTO;
import ec.tws2.back.lhia.go.dto.EmailBankCheckDTO;
import ec.tws2.back.lhia.go.dto.MetaAttachmentResponse;
import ec.tws2.back.lhia.go.dto.MetaDTO;
import ec.tws2.back.lhia.go.dto.ProcessVoucherDTO;
import ec.tws2.back.lhia.go.dto.ResponseVoucherDTO;
import ec.tws2.back.lhia.go.dto.SendEmailVoucherDTO;
import ec.tws2.back.lhia.go.dto.SendVoucherDTO;
import ec.tws2.back.lhia.go.dto.ValidVoucherDTO;
import ec.tws2.back.lhia.go.dto.VerifyVoucherDTO;
import ec.tws2.back.lhia.go.entity.FileDocument;
import ec.tws2.back.lhia.go.service.EmailService;
import ec.tws2.back.lhia.go.service.FileDocumentService;
import ec.tws2.back.lhia.go.service.VoucherService;
import ec.tws2.back.lhia.go.util.ConvertJsonUtil;
import ec.tws2.back.lhia.go.util.EmailUtil;
import ec.tws2.back.lhia.go.util.FileUtil;
import ec.tws2.back.lhia.go.util.HttpUtil;
import ec.tws2.back.lhia.go.util.ImageGrayUtil;
import ec.tws2.back.lhia.go.util.PromptUtil;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class VoucherServiceImpl
implements VoucherService {
    private static final Logger log = LoggerFactory.getLogger(VoucherServiceImpl.class);
    @Value(value="${lhia.domain.url}")
    private String appDomainUrl;
    @Autowired
    private ImageRecognitionApi imageRecognitionApi;
    @Autowired
    private EmailApi emailApi;
    @Autowired
    private FileDocumentService fileDocumentService;
    @Autowired
    private EmailService emailService;
    @Autowired
    private MetaApi metaApi;

    public ResponseEntity<ResponseResult<?>> sendEmailBankCheck(EmailBankCheckDTO dto) {
        log.info("Iniciando env\u00edo de email para cheque. DTO: {}", (Object)dto);
        Optional fileDocumentOptV1 = this.fileDocumentService.getById(dto.getFileIdAnverso());
        if (fileDocumentOptV1.isEmpty()) {
            log.error("No se encontr\u00f3 el FileDocument con ID: {}", (Object)dto.getFileIdAnverso());
            return TransactionCustom.error((StatusTransactions)StatusTransactions.ERROR, (String)"Archivo no encontrado");
        }
        Optional fileDocumentOptV2 = this.fileDocumentService.getById(dto.getFileIdReverso());
        if (fileDocumentOptV2.isEmpty()) {
            log.error("No se encontr\u00f3 el FileDocument con ID: {}", (Object)dto.getFileIdReverso());
            return TransactionCustom.error((StatusTransactions)StatusTransactions.ERROR, (String)"Archivo no encontrado");
        }
        String frontImageBlock = this.appDomainUrl + "/fileDocument/assets/" + dto.getFileIdAnverso();
        String backImageBlock = this.appDomainUrl + "/fileDocument/assets/" + dto.getFileIdReverso();
        String htmlEmailContent = EmailUtil.buildChequeEmailTemplateFull((ChequeBankAnversoJSON)dto.getChequeAnverso(), (ChequeBankReversoJSON)dto.getChequeReverso(), (String)frontImageBlock, (String)backImageBlock);
        log.debug("HTML generado para correo (preview 200 chars): {}", htmlEmailContent.length() > 200 ? htmlEmailContent.substring(0, 200) + "..." : htmlEmailContent);
        List emailList = this.getEmailList(dto);
        ArrayList fileVoucherList = new ArrayList();
        fileDocumentOptV1.ifPresent(doc -> fileVoucherList.add(this.buildFileVoucher("ChequeAnverso", "png", doc.getFileData())));
        fileDocumentOptV2.ifPresent(doc -> fileVoucherList.add(this.buildFileVoucher("ChequeReverso", "png", doc.getFileData())));
        EmailVoucher emailVoucherNew = new EmailVoucher();
        emailVoucherNew.setDestinatarios(emailList);
        emailVoucherNew.setContenido(htmlEmailContent);
        emailVoucherNew.setArchivos(fileVoucherList);
        log.debug("Objeto EmailVoucher construido correctamente: {}", (Object)emailVoucherNew);
        try {
            log.info("Llamando a emailApi.sendEmailBankCustom...");
            this.emailApi.sendEmailBankCustom(emailVoucherNew);
            log.info("Correo enviado con \u00e9xito a: {}", (Object)emailList);
            return TransactionCustom.ok();
        }
        catch (Exception e) {
            log.error("Error al enviar correo: {}", (Object)e.getMessage(), (Object)e);
            return TransactionCustom.error((StatusTransactions)StatusTransactions.ERROR, (String)("Error al enviar correo: " + e.getMessage()));
        }
    }

    public ResponseEntity<ResponseResult<?>> validateBankCheck(BankCheckDTO dto) {
        try {
            log.info("Iniciando validaci\u00f3n de cheque para DTO: {}", (Object)dto);
            String midId = (String)HttpUtil.getMidOfPath((String)dto.getImageUrl()).orElseThrow(() -> new IllegalArgumentException("URL no contiene mid v\u00e1lido"));
            log.info("Mid extra\u00eddo de la URL: {}", (Object)midId);
            MetaAttachmentResponse attachment = (MetaAttachmentResponse)this.metaApi.getMetaAttachment(midId).orElseThrow(() -> new IllegalStateException("No se pudo obtener attachment desde Meta"));
            log.info("Attachment obtenido: {}", (Object)attachment);
            MetaDTO metaDto = (MetaDTO)this.metaApi.downloadFileAndConvertToBase64(attachment.getUrl()).orElseThrow(() -> new IllegalStateException("No se pudo descargar ni convertir el archivo"));
            log.info("Archivo descargado y convertido a Base64. Tama\u00f1o: {}", (Object)(metaDto.getFileContentBase64() != null ? metaDto.getFileContentBase64().length() : 0));
            byte[] dataFile = ImageGrayUtil.convertirAGris((byte[])metaDto.getFileContentBytes());
            String dataFileString = FileUtil.byteToBase64((byte[])dataFile);
            FileDocument fileDocumentV1 = this.saveFileDocument(dataFileString, metaDto.getContentType());
            FileDocument fileDocumentV2 = this.saveFileDocument(metaDto.getFileContentBase64(), metaDto.getContentType());
            String pathImageDomain = this.appDomainUrl + "/fileDocument/assets/" + fileDocumentV1.getId();
            log.info("Archivo guardado en dominio: {}", (Object)pathImageDomain);
            String customPrompt = "ANVERSO".equals(dto.getType()) ? PromptUtil.validateChequeAnverso() : PromptUtil.validateChequeReverso();
            log.info("Prompt generado: {}", (Object)customPrompt);
            Optional dataRecognition = this.imageRecognitionApi.checkImageDocumentV2(pathImageDomain, customPrompt);
            if (dataRecognition.isEmpty()) {
                log.warn("No se obtuvo reconocimiento de cheque desde imageRecognitionApi");
                return TransactionCustom.error((StatusTransactions)StatusTransactions.ERROR, (String)"No se obtuvo informaci\u00f3n del cheque");
            }
            log.info("OCR Recognition obtenido: {}", (Object)((ProcessVoucherDTO)dataRecognition.get()).getDescription());
            if ("ANVERSO".equals(dto.getType())) {
                Optional chequeBankJSONOpt = ConvertJsonUtil.dataChequeAnversoJSON((String)((ProcessVoucherDTO)dataRecognition.get()).getDescription());
                if (chequeBankJSONOpt.isEmpty()) {
                    log.warn("No se pudo convertir el JSON del cheque");
                    return TransactionCustom.error((StatusTransactions)StatusTransactions.ERROR, (String)"Documento no v\u00e1lido");
                }
                HashMap<String, String> responseMap = new HashMap<String, String>();
                log.info("ChequeBankAnversoJSON parseado correctamente: {}", chequeBankJSONOpt.get());
                responseMap.put("fileId", fileDocumentV2.getId());
                responseMap.put("cheque", (String)chequeBankJSONOpt.get());
                responseMap.put("template", EmailUtil.buildChequeMessageAnverso((ChequeBankAnversoJSON)((ChequeBankAnversoJSON)chequeBankJSONOpt.get())));
                return TransactionCustom.ok(responseMap);
            }
            Optional chequeBankJSONOpt = ConvertJsonUtil.dataChequeReversoJSON((String)((ProcessVoucherDTO)dataRecognition.get()).getDescription());
            if (chequeBankJSONOpt.isEmpty()) {
                log.warn("No se pudo convertir el JSON del cheque");
                return TransactionCustom.error((StatusTransactions)StatusTransactions.ERROR, (String)"Documento no v\u00e1lido");
            }
            HashMap<String, String> responseMap = new HashMap<String, String>();
            log.info("ChequeBankAnversoJSON parseado correctamente: {}", chequeBankJSONOpt.get());
            responseMap.put("fileId", fileDocumentV2.getId());
            responseMap.put("cheque", (String)chequeBankJSONOpt.get());
            responseMap.put("template", EmailUtil.buildChequeMessageReverso((ChequeBankReversoJSON)((ChequeBankReversoJSON)chequeBankJSONOpt.get())));
            return TransactionCustom.ok(responseMap);
        }
        catch (Exception e) {
            log.error("Fallo en validateBankCheck: {}", (Object)e.getMessage(), (Object)e);
            return TransactionCustom.error((StatusTransactions)StatusTransactions.ERROR, (String)("Excepci\u00f3n en exportaci\u00f3n: " + e.getMessage()));
        }
    }

    public ResponseEntity<ResponseResult<?>> verifyVoucher(VerifyVoucherDTO verifyVoucherDTO) {
        log.info("[verifyVoucher] Iniciando verificaci\u00f3n de voucher");
        FileDocument fileDocument = this.saveFileDocument(verifyVoucherDTO.getFileBase64(), null);
        String pathImageDomain = this.appDomainUrl + "/fileDocument/assets/" + fileDocument.getId();
        log.info("[verifyVoucher] Documento guardado con id={}, path={}", (Object)fileDocument.getId(), (Object)pathImageDomain);
        Optional dataRecognition = this.imageRecognitionApi.checkImageDocument(pathImageDomain);
        if (!dataRecognition.isPresent()) {
            log.error("[verifyVoucher] Sin respuesta del servicio de reconocimiento de imagen para fileId={}", (Object)fileDocument.getId());
            return TransactionCustom.error((StatusTransactions)StatusTransactions.ERROR, (String)"Error al validar imagen.");
        }
        if (!((ProcessVoucherDTO)dataRecognition.get()).isValid()) {
            log.warn("[verifyVoucher] Imagen no v\u00e1lida para fileId={}", (Object)fileDocument.getId());
            return TransactionCustom.error((StatusTransactions)StatusTransactions.INVALID_INPUT, (String)"Imagen no v\u00e1lida.");
        }
        log.info("[verifyVoucher] Imagen v\u00e1lida, procesando descripci\u00f3n para fileId={}", (Object)fileDocument.getId());
        VoucherJSON voucherJson = ConvertJsonUtil.dataVoucherJSON((String)((ProcessVoucherDTO)dataRecognition.get()).getDescription());
        if (voucherJson == null) {
            log.error("[verifyVoucher] Error al parsear VoucherJSON para fileId={}, descripci\u00f3n={}", (Object)fileDocument.getId(), (Object)((ProcessVoucherDTO)dataRecognition.get()).getDescription());
            return TransactionCustom.error((StatusTransactions)StatusTransactions.ERROR, (String)"Error al validar imagen.");
        }
        log.info("[verifyVoucher] Voucher procesado exitosamente para fileId={}", (Object)fileDocument.getId());
        ResponseVoucherDTO responseVoucherDTO = new ResponseVoucherDTO(fileDocument.getId(), voucherJson);
        return TransactionCustom.ok((Object)responseVoucherDTO);
    }

    public ResponseEntity<ResponseResult<?>> sendVoucher(SendVoucherDTO sendVoucherDTO) {
        Optional fileDocument = this.fileDocumentService.getById(sendVoucherDTO.getIdFile());
        if (!fileDocument.isPresent()) {
            return TransactionCustom.error((StatusTransactions)StatusTransactions.ERROR, (String)"Archivo no encontrado.");
        }
        byte[] dataFile = ((FileDocument)fileDocument.get()).getFileData();
        ValidVoucherDTO validVoucherDTO = new ValidVoucherDTO();
        validVoucherDTO.setFileBase64(Base64.getEncoder().encodeToString(dataFile));
        validVoucherDTO.setEmail(sendVoucherDTO.getDetailVoucherDTO().getEmail());
        validVoucherDTO.setObservation(sendVoucherDTO.getDetailVoucherDTO().getObservation());
        validVoucherDTO.setUser(sendVoucherDTO.getDetailVoucherDTO().getUser());
        boolean dataSendEmail = this.sendEmail(sendVoucherDTO.getVoucherJson(), validVoucherDTO.fileBase64, validVoucherDTO);
        if (dataSendEmail) {
            return TransactionCustom.ok();
        }
        return TransactionCustom.error((StatusTransactions)StatusTransactions.ERROR, (String)"Error al enviar email.");
    }

    public ResponseEntity<ResponseResult<?>> validVoucher(ValidVoucherDTO validVoucherDTO) {
        FileDocument fileDocument = this.saveFileDocument(validVoucherDTO.getFileBase64(), null);
        String pathImageDomain = this.appDomainUrl + "/fileDocument/assets/" + fileDocument.getId();
        Optional dataRecognition = this.imageRecognitionApi.checkImageDocument(pathImageDomain);
        if (!dataRecognition.isPresent()) {
            return TransactionCustom.error((StatusTransactions)StatusTransactions.ERROR, (String)"Error al validar imagen.");
        }
        if (!((ProcessVoucherDTO)dataRecognition.get()).isValid()) {
            return TransactionCustom.error((StatusTransactions)StatusTransactions.INVALID_INPUT, (String)"Imagen no v\u00e1lida.");
        }
        VoucherJSON voucherJson = ConvertJsonUtil.dataVoucherJSON((String)((ProcessVoucherDTO)dataRecognition.get()).getDescription());
        if (voucherJson == null) {
            return TransactionCustom.error((StatusTransactions)StatusTransactions.ERROR, (String)"Error al validar imagen.");
        }
        boolean dataSendEmail = this.sendEmail(voucherJson, validVoucherDTO.fileBase64, validVoucherDTO);
        SendEmailVoucherDTO sendEmailVoucherDTO = new SendEmailVoucherDTO(dataSendEmail, voucherJson);
        return TransactionCustom.ok((Object)sendEmailVoucherDTO);
    }

    private FileVoucher buildFileVoucher(String prefix, String extension, byte[] data) {
        FileVoucher fv = new FileVoucher();
        fv.setFileName(EmailUtil.generateFileName((String)prefix, (String)extension));
        fv.setFileBase64(FileUtil.byteToBase64((byte[])data));
        return fv;
    }

    private List<String> getEmailList(EmailBankCheckDTO dto) {
        ArrayList<String> emails = new ArrayList<String>(dto.getEmails());
        emails.add("jrivera@tws2.io");
        HashSet uniqueEmails = new HashSet(emails);
        ArrayList<String> emailList = new ArrayList<String>(uniqueEmails);
        log.info("Destinatarios del correo: {}", emailList);
        return emailList;
    }

    public boolean sendEmail(VoucherJSON voucherJSON, String fileBase64, ValidVoucherDTO validVoucherDTO) {
        try {
            ArrayList<String> emailList = new ArrayList<String>();
            if (validVoucherDTO.getEmail() != null) {
                emailList.add(validVoucherDTO.getEmail());
            }
            this.emailService.getEmailsByStatus().stream().map(emailItem -> emailItem.getEmail()).forEach(emailList::add);
            if (!emailList.isEmpty()) {
                return this.emailApi.sendEmailBank(voucherJSON, fileBase64, validVoucherDTO, emailList);
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public FileDocument saveFileDocument(String fileBase64, String contentType) {
        FileDocument doc = new FileDocument();
        doc.setId(UUID.randomUUID().toString());
        doc.setFileData(Base64.getDecoder().decode(fileBase64));
        doc.setFileType(contentType != null ? contentType : "image/png");
        return this.fileDocumentService.save(doc);
    }
}

