/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.go.service.impl;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import ec.tws2.back.lhia.go.dto.FacturasModel;
import ec.tws2.back.lhia.go.service.ReadJsonService;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ReadJsonServiceImpl
implements ReadJsonService {
    private static final Logger log = LoggerFactory.getLogger(ReadJsonServiceImpl.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<FacturasModel> consumirJsonFacturas() {
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("facturas.json");){
            List facturas;
            if (inputStream == null) {
                log.error("No se encontr\u00f3 el archivo facturas.json en el classpath.");
                ArrayList<FacturasModel> arrayList = new ArrayList<FacturasModel>();
                return arrayList;
            }
            ObjectMapper objectMapper = new ObjectMapper();
            List list = facturas = (List)objectMapper.readValue(inputStream, (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, FacturasModel.class));
            return list;
        }
        catch (IOException e) {
            log.error("Error al leer el archivo JSON", (Throwable)e);
            return new ArrayList<FacturasModel>();
        }
    }

    public List<FacturasModel> buscarFacturasPorCedula(String cedula) {
        List facturas = this.consumirJsonFacturas();
        ArrayList<FacturasModel> facturasPorCedula = new ArrayList<FacturasModel>();
        for (FacturasModel factura : facturas) {
            if (!factura.getInformacionCliente().getNumeroIdentificacion().equals(cedula)) continue;
            facturasPorCedula.add(factura);
        }
        return facturasPorCedula;
    }
}

