/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.go.service.impl;

import ec.tws2.back.lhia.go.dao.FileDocumentDAO;
import ec.tws2.back.lhia.go.entity.FileDocument;
import ec.tws2.back.lhia.go.service.FileDocumentService;
import ec.tws2.back.lhia.go.util.FileUtil;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
public class FileDocumentServiceImpl
implements FileDocumentService {
    @Autowired
    private FileDocumentDAO fileDocumentDAO;

    public FileDocument save(FileDocument fileDocument) {
        return (FileDocument)this.fileDocumentDAO.save((Object)fileDocument);
    }

    public Optional<FileDocument> getById(String id) {
        return this.fileDocumentDAO.findById((Object)id);
    }

    public ResponseEntity<byte[]> findFileDocumentById(String id) {
        Optional documentFile = this.getById(id);
        if (documentFile.isPresent()) {
            HttpHeaders headers = new HttpHeaders();
            String fileType = FileUtil.determineFileType((String)((FileDocument)documentFile.get()).getFileType());
            if (fileType == null) {
                return new ResponseEntity((HttpStatusCode)HttpStatus.UNSUPPORTED_MEDIA_TYPE);
            }
            headers.setContentType(MediaType.parseMediaType((String)fileType));
            return new ResponseEntity((Object)((FileDocument)documentFile.get()).getFileData(), (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }
}

