/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.go.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Calendar;
import java.util.Date;

@Entity
@Table(name="t_file_document")
public class FileDocument {
    @Id
    @Column(nullable=false, length=255)
    private String id;
    @Column(name="file_year", nullable=false)
    private int fileYear;
    @Column(name="file_month", nullable=false)
    private int fileMonth;
    @Column(name="file_data", nullable=false)
    private byte[] fileData;
    @Column(name="file_type")
    private String fileType;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdAt;

    @PrePersist
    protected void onCreate() {
        this.createdAt = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.createdAt);
        this.fileYear = calendar.get(1);
        this.fileMonth = calendar.get(2) + 1;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getFileYear() {
        return this.fileYear;
    }

    public void setFileYear(int fileYear) {
        this.fileYear = fileYear;
    }

    public int getFileMonth() {
        return this.fileMonth;
    }

    public void setFileMonth(int fileMonth) {
        this.fileMonth = fileMonth;
    }

    public byte[] getFileData() {
        return this.fileData;
    }

    public void setFileData(byte[] fileData) {
        this.fileData = fileData;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }
}

