/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.go.dao;

import ec.tws2.back.lhia.go.data.UsuariosConsumo;
import ec.tws2.back.lhia.go.data.UsuariosPorDias;
import ec.tws2.back.lhia.go.entity.Conversacion;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ConversacionDAO
extends JpaRepository<Conversacion, Long> {
    @Query(value="select tr.id_roles AS id, tr.descripcion as rol, count( distinct tc.*) as usuarios from t_conversacion tc, t_roles tr, t_actividad ta  where tc.id_roles=tr.id_roles and ta.id_conversacion = tc.id_conversacion and ta.fecha >= :fecha1 and ta.fecha <= :fecha2 group by  tr.id_roles ORDER BY usuarios desc", nativeQuery=true)
    public List<UsuariosConsumo> listadoUsuarios(@Param(value="fecha1") Date var1, @Param(value="fecha2") Date var2);

    public boolean existsByIdentificador(String var1);

    public Optional<Conversacion> findByIdentificador(String var1);

    @Query(value="SELECT \r\n    EXTRACT(DAY FROM tcd.fecha) AS numero_dia,\r\n    DATE(tcd.fecha) AS fecha,\r\n    TO_CHAR(tcd.fecha, 'TMDay') AS nombre_dia,\r\n    COUNT(DISTINCT tc.id_conversacion) AS numero_usuarios\r\nFROM \r\n    t_conversacion tc\r\nJOIN \r\n    t_roles tr ON tr.id_roles = tc.id_roles\r\nJOIN \r\n    t_conversacion_detalle tcd ON tcd.id_conversacion = tc.id_conversacion\r\nWHERE \r\n    tcd.fecha >= :fecha1 \r\n    AND tcd.fecha <= :fecha2 \r\n    AND tr.descripcion = :rol\r\nGROUP BY \r\n    DATE(tcd.fecha), \r\n    EXTRACT(DAY FROM tcd.fecha), \r\n    TO_CHAR(tcd.fecha, 'TMDay')\r\nORDER BY \r\n    DATE(tcd.fecha) DESC;", nativeQuery=true)
    public List<UsuariosPorDias> listadoUsuariosPorDias(@Param(value="fecha1") Date var1, @Param(value="fecha2") Date var2, @Param(value="rol") String var3);

    @Query(value="SELECT SUM(numero_usuarios) AS total_usuarios FROM ( SELECT COUNT(DISTINCT tc.id_conversacion) AS numero_usuarios FROM t_conversacion tc JOIN t_roles tr ON tr.id_roles = tc.id_roles JOIN t_conversacion_detalle tcd ON tcd.id_conversacion = tc.id_conversacion WHERE tcd.fecha >= :fecha1 AND tcd.fecha <= :fecha2 AND tr.descripcion =:rol GROUP BY DATE(tcd.fecha), EXTRACT(DAY FROM tcd.fecha), TO_CHAR(tcd.fecha, 'TMDay') ORDER BY DATE(tcd.fecha) DESC ) AS subconsulta;", nativeQuery=true)
    public String totalUsuarios(@Param(value="fecha1") Date var1, @Param(value="fecha2") Date var2, @Param(value="rol") String var3);
}

