/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.go.controller;

import ec.tws2.back.lhia.go.dao.DocumentoDAO;
import ec.tws2.back.lhia.go.dao.SeccionDocumentoDAO;
import ec.tws2.back.lhia.go.dao.SeccionInventarioDAO;
import ec.tws2.back.lhia.go.data.ActualizacionConsumo;
import ec.tws2.back.lhia.go.data.CalificacionConsumo;
import ec.tws2.back.lhia.go.data.CalificacionRespuesta;
import ec.tws2.back.lhia.go.data.ClienteConsumo;
import ec.tws2.back.lhia.go.data.DatosEntrenados;
import ec.tws2.back.lhia.go.data.Gobernanza;
import ec.tws2.back.lhia.go.data.RespuestaRobot;
import ec.tws2.back.lhia.go.data.RolesPreguntas;
import ec.tws2.back.lhia.go.data.TemasConsumo;
import ec.tws2.back.lhia.go.data.UsuariosConsumo;
import ec.tws2.back.lhia.go.data.UsuariosPorDias;
import ec.tws2.back.lhia.go.entity.Actividad;
import ec.tws2.back.lhia.go.entity.Calificacion;
import ec.tws2.back.lhia.go.entity.Documento;
import ec.tws2.back.lhia.go.entity.SeccionDocumento;
import ec.tws2.back.lhia.go.service.GoRepository;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"dego"})
public class ProductController {
    @Autowired
    GoRepository goRepository;
    @Autowired
    SeccionDocumentoDAO seccionDocumentoDAO;
    @Autowired
    SeccionInventarioDAO seccionInventarioDAO;
    @Autowired
    DocumentoDAO documentoDAO;

    @GetMapping(value={"/anonimo"})
    public String saludo1() {
        return "Hola anonimo";
    }

    @GetMapping(value={"/admin"})
    public String saludo2() {
        return "Hola admin";
    }

    @GetMapping(value={"/user"})
    public String saludo3() {
        return "Hola user";
    }

    @PostMapping(value={"/questionProductos"}, consumes={"application/json"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    @PreAuthorize(value="hasRole('user')")
    public CompletableFuture<RespuestaRobot> getProduct(@RequestBody ClienteConsumo cliente) {
        return CompletableFuture.supplyAsync(() -> {
            RespuestaRobot robot = new RespuestaRobot();
            try {
                String answer = this.goRepository.consultaMilvus(cliente.getQuestion(), cliente.getIdentificador());
                robot.setRespuesta(answer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return robot;
        });
    }

    @PostMapping(value={"/questionProductosUlpik"}, consumes={"application/json"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    @PreAuthorize(value="hasRole('user')")
    public CompletableFuture<RespuestaRobot> getProductUlpik(@RequestBody ClienteConsumo cliente) {
        return CompletableFuture.supplyAsync(() -> {
            RespuestaRobot robot = new RespuestaRobot();
            try {
                String answer = this.goRepository.consultaMilvusUlpik(cliente.getQuestion(), cliente.getIdentificador());
                robot.setRespuesta(answer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return robot;
        });
    }

    @PostMapping(value={"/questiontws"}, consumes={"application/json"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    @PreAuthorize(value="hasRole('user')")
    public CompletableFuture<RespuestaRobot> getInfoTWS(@RequestBody ClienteConsumo cliente) {
        return CompletableFuture.supplyAsync(() -> {
            RespuestaRobot robot = new RespuestaRobot();
            try {
                String answer = this.goRepository.chatTWS(cliente.getQuestion());
                robot.setRespuesta(answer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return robot;
        });
    }

    @PostMapping(value={"/questionCartera"}, consumes={"application/json"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    @PreAuthorize(value="hasRole('user')")
    public CompletableFuture<RespuestaRobot> getProductCartera(@RequestBody ClienteConsumo cliente) {
        return CompletableFuture.supplyAsync(() -> {
            RespuestaRobot robot = new RespuestaRobot();
            try {
                String answer = this.goRepository.consultaMilvusCartera(cliente.getQuestion(), cliente.getIdentificador());
                robot.setRespuesta(answer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return robot;
        });
    }

    @PostMapping(value={"/questionCompras"}, consumes={"application/json"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    @PreAuthorize(value="hasRole('user')")
    public CompletableFuture<RespuestaRobot> getProductCompras(@RequestBody ClienteConsumo cliente) {
        return CompletableFuture.supplyAsync(() -> {
            RespuestaRobot robot = new RespuestaRobot();
            try {
                String answer = this.goRepository.consultaMilvusCompras(cliente.getQuestion(), cliente.getIdentificador());
                robot.setRespuesta(answer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return robot;
        });
    }

    @PostMapping(value={"/lista/documentos/datosEntrenados"}, produces={"application/json"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    public List<DatosEntrenados> obtenerDatosEntrenados() {
        ArrayList<DatosEntrenados> lista_datos = new ArrayList<DatosEntrenados>();
        DatosEntrenados datos_1 = new DatosEntrenados("Documentos Entrenados", "Total de documentos entrenados", this.goRepository.obtenerNumeroDocumentosEntrenados(), "pi-list");
        DatosEntrenados datos_2 = new DatosEntrenados("Links de Documentos (No Disponible)", "Total de documentos disponibles para su descarga", this.goRepository.obtenerNumeroLinksDocumentos(), "pi-list");
        lista_datos.add(datos_1);
        lista_datos.add(datos_2);
        return lista_datos;
    }

    @PostMapping(value={"/lista/temas"}, produces={"application/json"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    public List<TemasConsumo> obtenerPreguntas(@RequestParam Date fecha1, Date fecha2, String rol) {
        return this.goRepository.obtenerTemas(fecha1, fecha2, "COLABORADOR");
    }

    @PostMapping(value={"/lista/preguntas"}, produces={"application/json"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    public List<Actividad> listadoActividadCarpetas(@RequestParam Long id, Date fecha1, Date fecha2) {
        return this.goRepository.listadoActividadCarpetas(id, fecha1, fecha2);
    }

    @PostMapping(value={"/lista/preguntas/paginado"}, produces={"application/json"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    public Page<Actividad> listadoActividadCarpetasPaginado(@RequestParam Long id, Date fecha1, Date fecha2, int pagina, int filas) {
        return this.goRepository.listadoActividadCarpetasPaginado(id, fecha1, fecha2, pagina, filas);
    }

    @PostMapping(value={"/lista/calificaciones"}, produces={"application/json"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    public List<CalificacionConsumo> obtenerCalificaciones(@RequestParam Date fecha1, Date fecha2, String rol) {
        return this.goRepository.obtenerCalificaciones(fecha1, fecha2, rol, Boolean.valueOf(true), "");
    }

    @PostMapping(value={"/lista/gobernanza"}, produces={"application/json"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    public List<Gobernanza> obtenerGovernanza(@RequestParam Date fecha1, Date fecha2, String rol) {
        return this.goRepository.obtenerGovernanza(fecha1, fecha2, rol);
    }

    @PostMapping(value={"/lista/calificaciones_malas"}, produces={"application/json"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    public List<Calificacion> obtenerCalificacionesMalas(@RequestParam Date fecha1, Date fecha2) {
        return this.goRepository.obtenerCalificacionesRespuestasMalas(fecha1, fecha2);
    }

    @PostMapping(value={"/lista/calificaciones_malas/envio"}, produces={"application/json"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    public ResponseEntity<Calificacion> obtenerCalificacionesMalas(@RequestParam Long id) {
        return this.goRepository.actualizarEnviadoCalificacionesMalas(id);
    }

    @PostMapping(value={"/lista/calificaciones_respuesta_usuario"}, produces={"application/json"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    public List<CalificacionConsumo> obtenerCalificacionesRespuestaUsuario(@RequestParam Date fecha1, Date fecha2, String rol) {
        return this.goRepository.obtenerCalificacionesRespuestaUsuario(fecha1, fecha2, rol);
    }

    @PostMapping(value={"/lista/rol/total_preguntas"}, produces={"application/json"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    public List<RolesPreguntas> obtenerNumeroPreguntasRol(@RequestParam Date fecha1, Date fecha2) {
        return this.goRepository.obtenerNumeroPreguntasRol(fecha1, fecha2);
    }

    @PostMapping(value={"/lista/rol/usuarios"}, produces={"application/json"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    public List<UsuariosConsumo> obtenerlistadoUsuarios(@RequestParam Date fecha1, Date fecha2) {
        return this.goRepository.obtenerlistadoUsuarios(fecha1, fecha2);
    }

    @PostMapping(value={"/lista/rol/total_de_usuarios"}, produces={"application/json"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    public int obtenerTotalUsuarios(@RequestParam Date fecha1, Date fecha2, String rol) {
        return this.goRepository.obtenerTotalUsuarios(fecha1, fecha2, rol);
    }

    @PostMapping(value={"/lista/rol/usuarios_dias"}, produces={"application/json"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    public List<Map<String, Object>> obtenerlistadoUsuariosPorDias(@RequestParam Date fecha1, Date fecha2, String rol) {
        List usuariosPorDias = this.goRepository.obtenerlistadoUsuariosPorDias(fecha1, fecha2, rol);
        HashMap<String, String> dayTranslations = new HashMap<String, String>();
        dayTranslations.put("Monday", "Lunes");
        dayTranslations.put("Tuesday", "Martes");
        dayTranslations.put("Wednesday", "Mi\u00e9rcoles");
        dayTranslations.put("Thursday", "Jueves");
        dayTranslations.put("Friday", "Viernes");
        dayTranslations.put("Saturday", "S\u00e1bado");
        dayTranslations.put("Sunday", "Domingo");
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (UsuariosPorDias usuarioPorDia : usuariosPorDias) {
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put("numero_dia", usuarioPorDia.getNumero_dia());
            item.put("fecha", usuarioPorDia.getFecha());
            item.put("nombre_dia", dayTranslations.getOrDefault(usuarioPorDia.getNombre_dia(), usuarioPorDia.getNombre_dia()));
            item.put("numero_usuarios", usuarioPorDia.getNumero_usuarios());
            result.add(item);
        }
        return result;
    }

    @PostMapping(value={"/lista/conversacion/tokens"}, produces={"application/json"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    public int obtenerTokens(@RequestParam Date fecha1, Date fecha2, String rol) {
        return this.goRepository.obtenerTokens(fecha1, fecha2, rol);
    }

    @PostMapping(value={"/lista/calificacion_conversacion"}, produces={"application/json"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    public List<Calificacion> obtenerConversacion(@RequestParam Long id_conversacion) {
        return this.goRepository.listadoCalificacionConversacion(id_conversacion);
    }

    @PostMapping(value={"/lista/actualizaciones"}, produces={"application/json"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    public List<ActualizacionConsumo> obtenerActualizaciones(@RequestParam Date fecha1, Date fecha2) {
        return this.goRepository.obtenerActualizaciones(fecha1, fecha2);
    }

    @PostMapping(value={"/servicio/calificacion"}, consumes={"application/x-www-form-urlencoded"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    @PreAuthorize(value="hasRole('user')")
    public ResponseEntity<?> guardarCalificacion(@RequestParam String identificador, @RequestParam String calificacion, @RequestParam String pregunta, @RequestParam String respuesta) {
        return this.goRepository.guardarCalificacion(identificador, calificacion, pregunta, respuesta);
    }

    @PostMapping(value={"/servicio/calificacion_respuesta"}, consumes={"application/x-www-form-urlencoded"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    @PreAuthorize(value="hasRole('user')")
    public ResponseEntity<?> guardarCalificacionRespuestaUsuario(@RequestParam String identificador, @RequestParam String calificacion) {
        return this.goRepository.guardarCalificacionRespuestaUsuario(identificador, calificacion);
    }

    @GetMapping(value={"/generaEmb"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    public void generaEmb() {
        this.goRepository.generateEmbeddingsForProducts();
    }

    @PostMapping(value={"/proceso/nuevoProcesoBt"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    @PreAuthorize(value="hasRole('user')")
    public String nuevoProcesoBt(@RequestBody CalificacionRespuesta calificacionRespuesta) {
        String respuesta = this.goRepository.calificacionRespuesta(calificacionRespuesta);
        return respuesta;
    }

    @PostMapping(value={"/questionInventario"}, consumes={"application/json"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    @PreAuthorize(value="hasRole('user')")
    public CompletableFuture<RespuestaRobot> getProductPython(@RequestBody ClienteConsumo cliente) {
        return CompletableFuture.supplyAsync(() -> {
            RespuestaRobot robot = new RespuestaRobot();
            try {
                String answer = this.goRepository.consultaMilvusInventario(cliente.getQuestion(), cliente.getIdentificador());
                robot.setRespuesta(answer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return robot;
        });
    }

    @PostMapping(value={"/questionV4"}, consumes={"application/json"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    @PreAuthorize(value="hasRole('user')")
    public CompletableFuture<RespuestaRobot> getProductPgVector(@RequestBody ClienteConsumo cliente) {
        return CompletableFuture.supplyAsync(() -> {
            RespuestaRobot robot = new RespuestaRobot();
            String answer = this.goRepository.preguntaPgVector(cliente.getQuestion(), cliente.getDescripcion(), cliente.getIdentificador(), cliente.getUsuario(), cliente.getLstConversation());
            robot.setRespuesta(answer);
            return robot;
        });
    }

    @PostMapping(value={"/productos"}, consumes={"application/json"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    @PreAuthorize(value="hasRole('user')")
    public CompletableFuture<RespuestaRobot> getProducto(@RequestBody ClienteConsumo cliente) {
        return CompletableFuture.supplyAsync(() -> {
            RespuestaRobot robot = new RespuestaRobot();
            String answer = this.goRepository.preguntaMilvus(cliente.getQuestion(), cliente.getDescripcion(), cliente.getIdentificador(), cliente.getUsuario(), cliente.getLstConversation());
            robot.setRespuesta(answer);
            return robot;
        });
    }

    @PostMapping(value={"/inventario"}, consumes={"application/json"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    @PreAuthorize(value="hasRole('user')")
    public CompletableFuture<RespuestaRobot> getInventario(@RequestBody ClienteConsumo cliente) {
        return CompletableFuture.supplyAsync(() -> {
            RespuestaRobot robot = new RespuestaRobot();
            String answer = this.goRepository.preguntaMilvus(cliente.getQuestion(), cliente.getDescripcion(), cliente.getIdentificador(), cliente.getUsuario(), cliente.getLstConversation());
            robot.setRespuesta(answer);
            return robot;
        });
    }

    @PostMapping(value={"/cliente"}, consumes={"application/json"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    @PreAuthorize(value="hasRole('user')")
    public RespuestaRobot getCliente(@RequestBody ClienteConsumo cliente) {
        RespuestaRobot robot = new RespuestaRobot();
        try {
            String answer = this.goRepository.chatCliente(cliente.getQuestion(), cliente.getIdentificador());
            robot.setRespuesta(answer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return robot;
    }

    @PostMapping(value={"/excel-productos"})
    public ResponseEntity<List<List<String>>> uploadExcel(@RequestParam MultipartFile file) {
        try {
            int i;
            List data = this.goRepository.readExcel(file);
            ArrayList<String> nombres = new ArrayList<String>();
            ArrayList<String> caracteristicas = new ArrayList<String>();
            System.out.println(data.size());
            for (i = 1; i < data.size(); ++i) {
                List row = (List)data.get(i);
                String nombre = (String)row.get(0);
                String caracteristica = row.size() > 1 ? (String)row.get(1) : "";
                nombres.add(nombre);
                caracteristicas.add(caracteristica);
            }
            for (i = 0; i < nombres.size(); ++i) {
                System.out.println((String)nombres.get(i) + " " + (String)caracteristicas.get(i) + "\n");
                SeccionDocumento seccion = new SeccionDocumento();
                seccion.setDocumento((Documento)this.documentoDAO.findById((Object)2L).get());
                seccion.setEmbedding("");
                seccion.setGenerado(Long.valueOf(0L));
                seccion.setScore(0.0);
                seccion.setTexto((String)nombres.get(i) + " caracteristicas: " + (String)caracteristicas.get(i));
                this.seccionDocumentoDAO.save((Object)seccion);
            }
            return ResponseEntity.ok((Object)data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((int)500).body(null);
        }
    }

    @PostMapping(value={"/excel-inventario"})
    public ResponseEntity<?> uploadExcelInventario(@RequestParam(value="file") MultipartFile file) {
        try {
            this.goRepository.readExcel2(file);
            return ResponseEntity.ok(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((int)500).body(null);
        }
    }

    @PostMapping(value={"/excel-cartera"})
    public ResponseEntity<?> uploadExcelCartera(@RequestParam(value="file") MultipartFile file) {
        try {
            this.goRepository.leerDatosCarteraDesdeExcel(file);
            return ResponseEntity.ok(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((int)500).body(null);
        }
    }

    @PostMapping(value={"/excel-compras"})
    public ResponseEntity<?> uploadExcelCompras(@RequestParam(value="file") MultipartFile file) {
        try {
            this.goRepository.leerDatosComprasDesdeExcel(file);
            return ResponseEntity.ok(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((int)500).body(null);
        }
    }

    @PostMapping(value={"/excel-inventario-datos"})
    public ResponseEntity<?> uploadExcelInventarioDatos(@RequestParam(value="file") MultipartFile file) {
        try {
            this.goRepository.readExcel3(file);
            return ResponseEntity.ok(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((int)500).body(null);
        }
    }
}

