/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.go.client;

import ec.tws2.back.lhia.go.dto.MetaAttachmentResponse;
import ec.tws2.back.lhia.go.dto.MetaDTO;
import java.net.URI;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class MetaApi {
    private static final Logger log = LoggerFactory.getLogger(MetaApi.class);
    @Value(value="${whatsapp.api.key}")
    private String token;

    public Optional<MetaAttachmentResponse> getMetaAttachment(String mid) {
        RestTemplate restTemplate = new RestTemplate();
        String url = "https://graph.facebook.com/v19.0/" + mid;
        HttpHeaders headers = new HttpHeaders();
        headers.setBearerAuth(this.token);
        headers.setAccept(List.of(MediaType.APPLICATION_JSON));
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = restTemplate.exchange(url, HttpMethod.GET, entity, MetaAttachmentResponse.class, new Object[0]);
        if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null) {
            return Optional.of((MetaAttachmentResponse)response.getBody());
        }
        return Optional.empty();
    }

    public Optional<MetaDTO> downloadFileAndConvertToBase64(String imageUrl) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.set("Authorization", "Bearer " + this.token);
            RequestEntity request = new RequestEntity((MultiValueMap)headers, HttpMethod.GET, new URI(imageUrl));
            RestTemplate restTemplate = new RestTemplate();
            ResponseEntity response = restTemplate.exchange(request, byte[].class);
            if (response.getStatusCode().value() == 200) {
                byte[] fileContent = (byte[])response.getBody();
                String base64File = Base64.getEncoder().encodeToString(fileContent);
                String contentType = response.getHeaders().getContentType().toString();
                MetaDTO metaDTO = new MetaDTO();
                metaDTO.setContentType(contentType);
                metaDTO.setFileContentBase64(base64File);
                metaDTO.setFileContentBytes(fileContent);
                return Optional.of(metaDTO);
            }
            return Optional.empty();
        }
        catch (HttpClientErrorException e) {
            log.error("Error al descargar imagen de WhatsApp. Status: {}", (Object)e.getStatusCode());
            return Optional.empty();
        }
        catch (Exception e) {
            log.error("Error al descargar imagen de WhatsApp: {}", (Object)e.getMessage());
            return Optional.empty();
        }
    }
}

