/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.go.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import ec.tws2.back.lhia.go.dto.ProcessVoucherDTO;
import ec.tws2.back.lhia.go.util.PromptUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ImageRecognitionApi {
    private static final Logger log = LoggerFactory.getLogger(ImageRecognitionApi.class);
    @Value(value="${openai.urlAnswer2}")
    private String urlAnswer;
    @Value(value="${openai.modelAnswer4}")
    private String modelAnswer;
    @Value(value="${openai.apiKey2}")
    private String apiKey;

    public Optional<ProcessVoucherDTO> checkImageDocumentV2(String urlImage, String customPrompt) {
        String urlAnswerV1 = this.urlAnswer.trim();
        String modelAnswerV1 = this.modelAnswer.trim();
        String apiKeyV1 = this.apiKey.trim();
        HttpHeaders headers = ImageRecognitionApi.createHeaders((String)apiKeyV1);
        Map requestBody = ImageRecognitionApi.createRequestBodyCustomPrompt((String)urlImage, (String)modelAnswerV1, (int)3100, (String)customPrompt);
        HttpEntity entity = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
        RestTemplate restTemplate = new RestTemplate();
        try {
            ResponseEntity response = restTemplate.exchange(urlAnswerV1, HttpMethod.POST, entity, String.class, new Object[0]);
            if (!ImageRecognitionApi.isJsonResponse((ResponseEntity)response)) {
                log.error("Error: Response is not JSON");
                return Optional.empty();
            }
            return Optional.of(ImageRecognitionApi.processResponse((String)((String)response.getBody())));
        }
        catch (HttpClientErrorException | HttpServerErrorException e) {
            log.error("HTTP error: {} - {}", (Object)e.getStatusCode(), (Object)e.getResponseBodyAsString());
            log.debug("Request Body: {}", entity.getBody());
        }
        catch (Exception e) {
            log.error("General error: {}", (Object)e.getMessage(), (Object)e);
        }
        return Optional.empty();
    }

    public Optional<ProcessVoucherDTO> checkImageDocument(String urlImage) {
        log.info("[checkImageDocument] Iniciando reconocimiento de imagen, url={}", (Object)urlImage);
        String urlAnswerV1 = this.urlAnswer.trim();
        String modelAnswerV1 = this.modelAnswer.trim();
        String apiKeyV1 = this.apiKey.trim();
        String customPrompt = PromptUtil.getPromptValidVoucherBank();
        log.debug("[checkImageDocument] Usando modelo={}, endpoint={}", (Object)modelAnswerV1, (Object)urlAnswerV1);
        HttpHeaders headers = ImageRecognitionApi.createHeaders((String)apiKeyV1);
        Map requestBody = ImageRecognitionApi.createRequestBodyCustomPrompt((String)urlImage, (String)modelAnswerV1, (int)300, (String)customPrompt);
        HttpEntity entity = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
        RestTemplate restTemplate = new RestTemplate();
        try {
            log.info("[checkImageDocument] Enviando solicitud al API de reconocimiento");
            ResponseEntity response = restTemplate.exchange(urlAnswerV1, HttpMethod.POST, entity, String.class, new Object[0]);
            log.info("[checkImageDocument] Respuesta recibida, status={}", (Object)response.getStatusCode());
            log.debug("[checkImageDocument] Response body={}", response.getBody());
            if (!ImageRecognitionApi.isJsonResponse((ResponseEntity)response)) {
                log.error("[checkImageDocument] La respuesta no es JSON v\u00e1lido, body={}", response.getBody());
                return Optional.empty();
            }
            ProcessVoucherDTO result = ImageRecognitionApi.processResponse((String)((String)response.getBody()));
            log.info("[checkImageDocument] Procesamiento exitoso, isValid={}", (Object)result.isValid());
            return Optional.of(result);
        }
        catch (HttpClientErrorException | HttpServerErrorException e) {
            log.error("[checkImageDocument] HTTP error: {} - {}", (Object)e.getStatusCode(), (Object)e.getResponseBodyAsString());
            log.debug("[checkImageDocument] Request Body: {}", entity.getBody());
        }
        catch (Exception e) {
            log.error("[checkImageDocument] General error: {}", (Object)e.getMessage(), (Object)e);
        }
        return Optional.empty();
    }

    public static HttpHeaders createHeaders(String apiKey) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(apiKey);
        return headers;
    }

    public static boolean isJsonResponse(ResponseEntity<String> response) {
        return response.getHeaders().getContentType().includes(MediaType.APPLICATION_JSON);
    }

    public static Map<String, Object> createRequestBody(String urlImage, String modelAnswer4, int maxTokens) {
        Map<String, String> message1 = Map.of("type", "text", "text", PromptUtil.getPromptValidVoucherBank());
        Map<String, Map<String, String>> message2 = Map.of("type", "image_url", "image_url", Map.of("url", urlImage));
        Map<String, List<Map>> userMessage = Map.of("role", "user", "content", Arrays.asList(message1, message2));
        return Map.of("model", modelAnswer4, "messages", Collections.singletonList(userMessage), "max_tokens", maxTokens);
    }

    public static Map<String, Object> createRequestBodyCustomPrompt(String urlImage, String modelAnswer4, int maxTokens, String customPrompt) {
        Map<String, String> message1 = Map.of("type", "text", "text", customPrompt);
        Map<String, Map<String, String>> message2 = Map.of("type", "image_url", "image_url", Map.of("url", urlImage));
        Map<String, List<Map>> userMessage = Map.of("role", "user", "content", Arrays.asList(message1, message2));
        return Map.of("model", modelAnswer4, "messages", Collections.singletonList(userMessage), "max_tokens", maxTokens);
    }

    public static ProcessVoucherDTO processResponse(String responseBody) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode rootNode = mapper.readTree(responseBody);
            String content = rootNode.path("choices").get(0).path("message").path("content").asText();
            int totalTokens = rootNode.path("usage").path("total_tokens").asInt();
            if (content.contains("documento_no_valido")) {
                String newContent = content.replace("documento_no_valido:", "");
                if (!newContent.isEmpty()) {
                    return new ProcessVoucherDTO(newContent.trim(), totalTokens, false);
                }
                return new ProcessVoucherDTO("La imagen no contiene informaci\u00f3n relacionada con un pago o transferencia", totalTokens, false);
            }
            return new ProcessVoucherDTO(content, totalTokens, true);
        }
        catch (Exception e) {
            return new ProcessVoucherDTO("La imagen no contiene informaci\u00f3n relacionada con un pago o transferencia", 0, false);
        }
    }
}

