/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.go.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import ec.tws2.back.lhia.go.data.EmailVoucher;
import ec.tws2.back.lhia.go.data.KeyCloak;
import ec.tws2.back.lhia.go.data.VoucherJSON;
import ec.tws2.back.lhia.go.dto.ValidVoucherDTO;
import ec.tws2.back.lhia.go.util.EmailUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class EmailApi {
    private static final Logger log = LoggerFactory.getLogger(EmailApi.class);
    @Value(value="${endpoint.admin.email_api}")
    private String adminEmailServerApi;
    @Value(value="${endpoint.admin.email_token}")
    private String adminEmailServerToken;
    @Value(value="${property.server.email_username}")
    private String adminEmailUsername;
    @Value(value="${property.server.email_password}")
    private String adminEmailPassword;
    @Value(value="${property.server.email_client_id}")
    private String adminEmailClientId;
    @Value(value="${property.server.email_grant_type}")
    private String adminEmailGrantType;
    @Value(value="${property.server.email_code_email_dev}")
    private String adminEmailCodeEmailDev;

    public String getTokenAdminEmail() throws Exception {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"client_id", (Object)this.adminEmailClientId);
        map.add((Object)"username", (Object)this.adminEmailUsername);
        map.add((Object)"grant_type", (Object)this.adminEmailGrantType);
        map.add((Object)"password", (Object)this.adminEmailPassword);
        HttpEntity entity = new HttpEntity((Object)map, (MultiValueMap)headers);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity answer = restTemplate.exchange(this.adminEmailServerToken, HttpMethod.POST, entity, KeyCloak.class, new Object[0]);
        return ((KeyCloak)answer.getBody()).getAccess_token();
    }

    public boolean sendEmailBank(VoucherJSON voucherJSON, String fileBase64, ValidVoucherDTO validVoucherDTO, List<String> emailList) throws Exception {
        String tokenAdminEmail = this.getTokenAdminEmail();
        EmailVoucher emailVoucher = EmailUtil.createEmailVoucherBank((VoucherJSON)voucherJSON, (String)fileBase64, (String)this.adminEmailCodeEmailDev, (ValidVoucherDTO)validVoucherDTO, emailList);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(tokenAdminEmail);
        ObjectMapper objectMapper = new ObjectMapper();
        String jsonEmailModel = objectMapper.writeValueAsString((Object)emailVoucher);
        HttpEntity request = new HttpEntity((Object)jsonEmailModel, (MultiValueMap)headers);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = restTemplate.postForEntity(this.adminEmailServerApi, (Object)request, Object.class, new Object[0]);
        System.out.println(response.getStatusCode());
        return response.getStatusCode() == HttpStatus.OK;
    }

    public boolean sendEmailBankCustom(EmailVoucher emailVoucherNew) throws Exception {
        String tokenAdminEmail = this.getTokenAdminEmail();
        EmailVoucher emailVoucherSend = new EmailVoucher();
        emailVoucherSend.setDestinatarios(emailVoucherNew.getDestinatarios());
        emailVoucherSend.setContenido(emailVoucherNew.getContenido());
        emailVoucherSend.setArchivos(emailVoucherNew.getArchivos());
        emailVoucherSend.setAsunto("Validaci\u00f3n de Cheque");
        emailVoucherSend.setContentisHtml(true);
        emailVoucherSend.setCodigoEmail(this.adminEmailCodeEmailDev);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(tokenAdminEmail);
        ObjectMapper objectMapper = new ObjectMapper();
        String jsonEmailModel = objectMapper.writeValueAsString((Object)emailVoucherSend);
        HttpEntity request = new HttpEntity((Object)jsonEmailModel, (MultiValueMap)headers);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = restTemplate.postForEntity(this.adminEmailServerApi, (Object)request, Object.class, new Object[0]);
        System.out.println(response.getStatusCode());
        return response.getStatusCode() == HttpStatus.OK;
    }
}

