/*
 * Decompiled with CFR 0.152.
 */
package com.ganansol.logic.service.impl;

import com.ganansol.logic.model.SeccionDocumento;
import com.ganansol.logic.repository.SeccionDocumentoDAO;
import com.ganansol.logic.service.SeccionDocumentoService;
import com.ganansol.utils.UtilLhia;
import java.util.List;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class SeccionDocumentoServiceImpl
implements SeccionDocumentoService {
    Logger log = Logger.getLogger(SeccionDocumentoServiceImpl.class.getName());
    @Value(value="${openai.apiKey}")
    private String apiKey;
    @Value(value="${openai.url}")
    private String url;
    @Autowired
    private SeccionDocumentoDAO seccionDAO;

    public List<SeccionDocumento> getPromptsByRole(String role) {
        this.log.info("OBTENIENDO LAS SECCIONDES DEL DOCUMENTO");
        return this.seccionDAO.findAllSectionsByRole(role);
    }

    public void generateEmbeddingsForSections() {
        List lstSeccion = this.seccionDAO.listadoProductosNG();
        for (SeccionDocumento seccion : lstSeccion) {
            String prompt = seccion.getTexto();
            System.out.println(prompt);
            String response = this.generateEmbedding(UtilLhia.quitarTildes((String)prompt.toUpperCase()));
            seccion.setEmbedding(response);
            seccion.setGenerado(Long.valueOf(1L));
            this.seccionDAO.save((Object)seccion);
        }
    }

    public String generateEmbedding(String prompt) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("input", (Object)prompt);
        jsonObject.put("model", (Object)"text-embedding-3-large");
        jsonObject.put("dimensions", 3072);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity requestEntity = new HttpEntity((Object)jsonObject.toString(), (MultiValueMap)headers);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity responseEntity = restTemplate.exchange(this.url, HttpMethod.POST, requestEntity, String.class, new Object[0]);
        JSONObject responseJson = new JSONObject((String)responseEntity.getBody());
        JSONArray embeddingArray = responseJson.getJSONArray("data");
        String embedding = embeddingArray.join("embedding");
        return UtilLhia.parseEmbedding((String)embedding);
    }
}

