/*
 * Decompiled with CFR 0.152.
 */
package com.ganansol.logic.service.impl;

import com.ganansol.logic.data.CalificacionConsumo;
import com.ganansol.logic.data.Gobernanza;
import com.ganansol.logic.model.CalificacionPregunta;
import com.ganansol.logic.model.CalificacionRespuestaUsuario;
import com.ganansol.logic.model.Conversacion;
import com.ganansol.logic.repository.CalificacionPreguntasDAO;
import com.ganansol.logic.repository.CalificacionRespuestaUsuarioDAO;
import com.ganansol.logic.repository.ConversacionDAO;
import com.ganansol.logic.service.GobernanzaService;
import com.ganansol.utils.DateUtils;
import com.ganansol.utils.UtilLhia;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class GobernanzaServiceImpl
implements GobernanzaService {
    @Autowired
    private ConversacionDAO conversacionDAO;
    @Autowired
    private CalificacionPreguntasDAO calificacionDAO;
    @Autowired
    private CalificacionRespuestaUsuarioDAO calificacionRespuestaUsuarioDAO;

    public List<Gobernanza> obtenerGovernanza(String fecha1, String fecha2, String rol) {
        LocalDateTime date1 = DateUtils.parseStringToLocalDateTime((String)fecha1);
        LocalDateTime date2 = DateUtils.parseStringToLocalDateTime((String)fecha2);
        List buenaList = this.calificacionDAO.listadoCalificacionFrecuencia(date1, date2, rol, Boolean.valueOf(true), "BUENA");
        List supervisadaList = this.calificacionDAO.listadoCalificacionFrecuencia(date1, date2, rol, Boolean.valueOf(false), "MALA");
        List malaList = this.calificacionDAO.listadoCalificacionFrecuencia(date1, date2, rol, Boolean.valueOf(true), "MALA");
        CalificacionConsumo calificacion_buena = buenaList.isEmpty() ? null : (CalificacionConsumo)buenaList.get(0);
        CalificacionConsumo calificacion_supervisada = supervisadaList.isEmpty() ? null : (CalificacionConsumo)supervisadaList.get(0);
        CalificacionConsumo calificacion_mala = malaList.isEmpty() ? null : (CalificacionConsumo)malaList.get(0);
        return Arrays.asList(new Gobernanza(1, "BUENA", Long.valueOf(calificacion_buena != null ? calificacion_buena.getFrecuencia() : 0L)), new Gobernanza(2, "SUPERVISADOS", Long.valueOf(calificacion_supervisada != null ? calificacion_supervisada.getFrecuencia() : 0L)), new Gobernanza(3, "MALA", Long.valueOf(calificacion_mala != null ? calificacion_mala.getFrecuencia() : 0L)));
    }

    public ResponseEntity<?> guardarCalificacionRespuestaUsuario(String identificador, String calificacion) {
        try {
            if (this.conversacionDAO.existsByIdentificador(identificador)) {
                CalificacionRespuestaUsuario calificacion_ = new CalificacionRespuestaUsuario();
                calificacion_.setCalificacion(calificacion);
                calificacion_.setId_conversacion((Conversacion)this.conversacionDAO.findByIdentificador(identificador).get());
                calificacion_.setFecha(UtilLhia.fechaEcuador());
                return ResponseEntity.ok((Object)((CalificacionRespuestaUsuario)this.calificacionRespuestaUsuarioDAO.save((Object)calificacion_)));
            }
            return ResponseEntity.notFound().build();
        }
        catch (Exception e) {
            return ResponseEntity.notFound().build();
        }
    }

    public List<CalificacionConsumo> obtenerCalificacionesRespuestaUsuario(String fecha1, String fecha2, String rol) {
        LocalDateTime date1 = DateUtils.parseStringToLocalDateTime((String)fecha1);
        LocalDateTime date2 = DateUtils.parseStringToLocalDateTime((String)fecha2);
        return this.calificacionRespuestaUsuarioDAO.listadoCalificacionRespuestaFrecuencia(date1, date2, rol);
    }

    public List<CalificacionPregunta> obtenerCalificacionesRespuestasMalas(String fecha1, String fecha2) {
        LocalDateTime date1 = DateUtils.parseStringToLocalDateTime((String)fecha1);
        LocalDateTime date2 = DateUtils.parseStringToLocalDateTime((String)fecha2);
        return this.calificacionDAO.listadoCalificacionRespuestasMalas(date1, date2);
    }

    public ResponseEntity<CalificacionPregunta> actualizarEnviadoCalificacionesMalas(Long id) {
        CalificacionPregunta c = (CalificacionPregunta)this.calificacionDAO.findById((Object)id).get();
        c.setEnviado(Boolean.valueOf(true));
        return ResponseEntity.ok((Object)((CalificacionPregunta)this.calificacionDAO.save((Object)c)));
    }
}

