/*
 * Decompiled with CFR 0.152.
 */
package com.ganansol.logic.service.impl;

import com.ganansol.logic.data.ActualizacionConsumo;
import com.ganansol.logic.model.DatosEntrenados;
import com.ganansol.logic.repository.ActualizacionesDAO;
import com.ganansol.logic.repository.DocumentoDAO;
import com.ganansol.logic.service.DocumentoActualizacionService;
import com.ganansol.utils.DateUtils;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DocumentoActualizacionServImp
implements DocumentoActualizacionService {
    @Autowired
    private ActualizacionesDAO actualizacionesDAO;
    @Autowired
    private DocumentoDAO documentoDAO;

    public List<ActualizacionConsumo> obtenerActualizaciones(String fecha1, String fecha2) {
        LocalDateTime date1 = DateUtils.parseStringToLocalDateTime((String)fecha1);
        LocalDateTime date2 = DateUtils.parseStringToLocalDateTime((String)fecha2);
        return this.actualizacionesDAO.listadoActualizaciones(date1, date2);
    }

    public List<DatosEntrenados> getDocumentosEntrenados() {
        List resultados = this.documentoDAO.getDocumentosEntrenado();
        return resultados.stream().map(DatosEntrenados::from).collect(Collectors.toList());
    }
}

