/*
 * Decompiled with CFR 0.152.
 */
package com.ganansol.logic.service.impl;

import com.ganansol.logic.data.UsuariosConsumo;
import com.ganansol.logic.model.Actividad;
import com.ganansol.logic.model.Carpeta;
import com.ganansol.logic.model.Conversacion;
import com.ganansol.logic.model.ConversacionDetalle;
import com.ganansol.logic.model.Documento;
import com.ganansol.logic.repository.ActividadDAO;
import com.ganansol.logic.repository.CarpetaDAO;
import com.ganansol.logic.repository.ConversacionDAO;
import com.ganansol.logic.repository.ConversacionDetalleDAO;
import com.ganansol.logic.repository.DocumentoDAO;
import com.ganansol.logic.repository.RolDAO;
import com.ganansol.logic.service.ConversacionService;
import com.ganansol.utils.DateUtils;
import com.ganansol.utils.UtilLhia;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ConversacionServiceImpl
implements ConversacionService {
    private static final Logger log = LoggerFactory.getLogger(ConversacionServiceImpl.class);
    @Autowired
    private ConversacionDAO conversacionDAO;
    @Autowired
    private ConversacionDetalleDAO conversacionDetalleDAO;
    @Autowired
    private RolDAO rolDAO;
    @Autowired
    private ActividadDAO actividadDAO;
    @Autowired
    private DocumentoDAO documentoDAO;
    @Autowired
    private CarpetaDAO carpetaDAO;
    private String textSystem = "";

    @Async
    public void guardarConversacion(String identificador, String usuario, String rol, String mensaje, double score, int prompts, String pregunta, String textSystem) {
        log.info("como llega la data antes de guardar la infortmacion antes de buscar" + usuario + rol);
        if (this.conversacionDAO.existsByIdentificador(identificador)) {
            if (!rol.isEmpty()) {
                ConversacionDetalle conversacion_detalle = new ConversacionDetalle();
                conversacion_detalle.setRol(rol);
                conversacion_detalle.setMensaje(mensaje);
                conversacion_detalle.setScore(score);
                conversacion_detalle.setTokens((long)prompts);
                conversacion_detalle.setConversacion((Conversacion)this.conversacionDAO.findByIdentificador(identificador).get());
                conversacion_detalle.setFecha(UtilLhia.fechaEcuador());
                conversacion_detalle.setPregunta(pregunta);
                this.conversacionDetalleDAO.save((Object)conversacion_detalle);
            }
        } else {
            Conversacion nueva_conversacion = new Conversacion();
            ConversacionDetalle conversacion_detalle = new ConversacionDetalle();
            log.info("como llega la data antes de guardar en else la infortmacion antes de buscar" + usuario + rol);
            nueva_conversacion.setUsuario(usuario);
            nueva_conversacion.setIdentificador(identificador);
            nueva_conversacion.setFecha(UtilLhia.fechaEcuador());
            nueva_conversacion.setRoles(this.rolDAO.findByDescripcion(rol));
            Conversacion aux = (Conversacion)this.conversacionDAO.save((Object)nueva_conversacion);
            conversacion_detalle.setRol("system");
            conversacion_detalle.setScore(0.0);
            conversacion_detalle.setMensaje(textSystem);
            conversacion_detalle.setTokens(0L);
            conversacion_detalle.setConversacion(aux);
            conversacion_detalle.setFecha(UtilLhia.fechaEcuador());
            conversacion_detalle.setPregunta("");
            this.conversacionDetalleDAO.save((Object)conversacion_detalle);
        }
    }

    public ResponseEntity<?> inicioConversacion(String identificador, String usuario, String rol) {
        if (!this.conversacionDAO.existsByIdentificador(identificador)) {
            Conversacion nueva_conversacion = new Conversacion();
            nueva_conversacion.setUsuario(usuario);
            nueva_conversacion.setIdentificador(identificador);
            nueva_conversacion.setRoles(this.rolDAO.findByDescripcion(rol));
            nueva_conversacion.setFecha(UtilLhia.fechaEcuador());
            return ResponseEntity.ok((Object)((Conversacion)this.conversacionDAO.save((Object)nueva_conversacion)));
        }
        return ResponseEntity.badRequest().build();
    }

    public void actividadConversacion(String identificador, String pregunta, String respuesta, String nombre_documento) {
        if (this.conversacionDAO.existsByIdentificador(identificador)) {
            Documento documento = this.documentoDAO.buscarPorNombre(nombre_documento);
            Carpeta carpeta = documento != null ? (Carpeta)this.carpetaDAO.findById((Object)documento.getCarpeta().getId()).get() : this.carpetaDAO.findByNombre(nombre_documento);
            Actividad actividad = new Actividad();
            actividad.setTexto_pregunta(pregunta);
            actividad.setTexto_respuesta(respuesta);
            actividad.setFecha(UtilLhia.fechaEcuador());
            actividad.setCarpetas(carpeta);
            actividad.setId_conversacion((Conversacion)this.conversacionDAO.findByIdentificador(identificador).get());
            this.actividadDAO.save((Object)actividad);
        }
    }

    public List<UsuariosConsumo> obtenerlistadoUsuarios(String fecha1, String fecha2) {
        LocalDateTime date1 = DateUtils.parseStringToLocalDateTime((String)fecha1);
        LocalDateTime date2 = DateUtils.parseStringToLocalDateTime((String)fecha2);
        return this.conversacionDAO.listadoUsuarios(date1, date2);
    }

    public void guardarConversacionV2(String identificador, String usuario, String rol, String pregunta, String respuesta, String adicional, double score, int tokens, String descripcion) {
        log.info("como llega la data antes de guardar la infortmacion antes de buscar" + identificador + usuario + rol + pregunta + respuesta + adicional + score + tokens + descripcion);
        if (this.conversacionDAO.existsByIdentificador(identificador)) {
            if (!rol.isEmpty()) {
                log.info("Entra si existe" + identificador + usuario + rol + pregunta + respuesta + adicional + score + tokens + descripcion);
                ConversacionDetalle conversacion_detalle = new ConversacionDetalle();
                conversacion_detalle.setRol(rol);
                conversacion_detalle.setPregunta(pregunta);
                conversacion_detalle.setMensaje(respuesta);
                conversacion_detalle.setScore(score);
                conversacion_detalle.setTokens((long)tokens);
                conversacion_detalle.setAdicional(adicional);
                conversacion_detalle.setConversacion((Conversacion)this.conversacionDAO.findByIdentificador(identificador).get());
                conversacion_detalle.setFecha(UtilLhia.fechaEcuador());
                this.conversacionDetalleDAO.save((Object)conversacion_detalle);
            }
        } else {
            log.info("No existe" + identificador + usuario + rol + pregunta + respuesta + adicional + score + tokens + descripcion);
            Conversacion nueva_conversacion = new Conversacion();
            ConversacionDetalle conversacion_detalle = new ConversacionDetalle();
            nueva_conversacion.setUsuario(usuario);
            nueva_conversacion.setIdentificador(identificador);
            nueva_conversacion.setRoles(this.rolDAO.findByDescripcion(rol));
            nueva_conversacion.setFecha(UtilLhia.fechaEcuador());
            Conversacion aux = (Conversacion)this.conversacionDAO.save((Object)nueva_conversacion);
            log.info("Informacion guardada; " + aux.toString());
            conversacion_detalle.setActor("system");
            conversacion_detalle.setScore(0.0);
            conversacion_detalle.setMensaje(this.textSystem);
            conversacion_detalle.setTokens(0L);
            conversacion_detalle.setConversacion(aux);
            conversacion_detalle.setRol(descripcion);
            conversacion_detalle.setFecha(UtilLhia.fechaEcuador());
            ConversacionDetalle conversaciondet = (ConversacionDetalle)this.conversacionDetalleDAO.save((Object)conversacion_detalle);
            log.info("Informacion guardada; " + conversaciondet.toString());
        }
    }
}

