/*
 * Decompiled with CFR 0.152.
 */
package com.ganansol.logic.service.impl;

import com.ganansol.logic.data.ConversacionUsuario;
import com.ganansol.logic.service.ChatApiservice;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class ChatApiServiceImpl
implements ChatApiservice {
    private final RestTemplate restTemplate = new RestTemplate();
    @Value(value="${openai.url}")
    private String url;
    @Value(value="${openai.urlAnswer2}")
    private String urlAnswer2;
    @Value(value="${openai.modelAnswer2}")
    private String modelAnswer2;
    @Value(value="${openai.apiKey}")
    private String apiKey;
    @Value(value="${openai.modelAnswer3}")
    private String modelAnswer3;
    @Value(value="${openai.urlAnswer3}")
    private String urlAnswer3;

    public String respondePreguntas(String prompt, Double temp) {
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("model", this.modelAnswer3);
        requestBody.put("prompt", prompt);
        requestBody.put("max_tokens", 250);
        requestBody.put("temperature", temp);
        requestBody.put("stop", "[\" user:\", \" assistant:\"]");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity request = new HttpEntity(requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.urlAnswer3, (Object)request, Map.class, new Object[0]);
        JSONObject responseJson = new JSONObject((Map)response.getBody());
        JSONArray embeddingArray = responseJson.getJSONArray("choices");
        JSONObject choiceObj = (JSONObject)embeddingArray.get(0);
        String text = (String)choiceObj.get("text");
        return text.replaceAll("Assistant:", "").replaceAll("assistant:", "").replaceAll("RESPUESTA:", "");
    }

    public String respondePreguntasV2(List<ConversacionUsuario> lstConversation) {
        JSONObject requestBody = new JSONObject();
        requestBody.put("messages", lstConversation);
        requestBody.put("model", (Object)this.modelAnswer2);
        requestBody.put("max_tokens", 450);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity request = new HttpEntity((Object)requestBody.toString(), (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.urlAnswer2, (Object)request, Map.class, new Object[0]);
        JSONObject responseJson = new JSONObject((Map)response.getBody());
        JSONArray embeddingArray = responseJson.getJSONArray("choices");
        JSONObject choiceObj = (JSONObject)embeddingArray.get(0);
        JSONObject messageObj = (JSONObject)choiceObj.get("message");
        String text = (String)messageObj.get("content");
        System.out.println("respuesta GPT: " + text);
        return text;
    }

    public String respondePreguntasV3(String pregunta, Double temp) {
        ArrayList<ConversacionUsuario> conversacionUsuario = new ArrayList<ConversacionUsuario>();
        conversacionUsuario.add(new ConversacionUsuario("user", pregunta));
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("model", this.modelAnswer2);
        requestBody.put("messages", conversacionUsuario);
        requestBody.put("max_tokens", 450);
        requestBody.put("temperature", temp);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity request = new HttpEntity(requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.urlAnswer2, (Object)request, Map.class, new Object[0]);
        JSONObject responseJson = new JSONObject((Map)response.getBody());
        JSONArray embeddingArray = responseJson.getJSONArray("choices");
        JSONObject choiceObj = (JSONObject)embeddingArray.get(0);
        JSONObject messageObj = (JSONObject)choiceObj.get("message");
        String text = (String)messageObj.get("content");
        return text;
    }
}

