/*
 * Decompiled with CFR 0.152.
 */
package com.ganansol.logic.service.impl;

import com.ganansol.logic.repository.CarpetaDAO;
import com.ganansol.logic.service.CarpetaService;
import com.ganansol.utils.DateUtils;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class CarpetaServiceImpl
implements CarpetaService {
    private static final Logger log = LoggerFactory.getLogger(CarpetaServiceImpl.class);
    @Autowired
    private CarpetaDAO carpetaDocDAO;

    public ResponseEntity<?> getTematicas(String fecha1, String fecha2) {
        try {
            LocalDateTime date1 = DateUtils.parseStringToLocalDateTime((String)fecha1);
            LocalDateTime date2 = DateUtils.parseStringToLocalDateTime((String)fecha2);
            List carpetas = this.carpetaDocDAO.findCarpetasByFechaRegistroBetween(date1, date2);
            log.info("mostrando respuesta de codigo: " + carpetas);
            return ResponseEntity.ok((Object)carpetas);
        }
        catch (Exception e) {
            log.error("Error al obtener las calificaciones: ", (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Collections.emptyList());
        }
    }
}

