/*
 * Decompiled with CFR 0.152.
 */
package com.ganansol.logic.service.impl;

import com.ganansol.logic.dto.interf.CalificacionInformativa;
import com.ganansol.logic.model.Calificacion;
import com.ganansol.logic.repository.CalificacionDAO;
import com.ganansol.logic.service.CalificacionService;
import com.ganansol.utils.DateUtils;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class CalificacionServiceImpl
implements CalificacionService {
    private static final Logger log = LoggerFactory.getLogger(CalificacionServiceImpl.class);
    @Autowired
    private CalificacionDAO calificacionDAO;

    public ResponseEntity<List<CalificacionInformativa>> getCalificaciones(String fecha1, String fecha2, String rol) {
        try {
            LocalDateTime date1 = DateUtils.parseStringToLocalDateTime((String)fecha1);
            LocalDateTime date2 = DateUtils.parseStringToLocalDateTime((String)fecha2);
            List calificaciones = this.calificacionDAO.getCalificacion(date1, date2, rol);
            log.info("mostrando respuesta de codigo: " + calificaciones);
            return ResponseEntity.ok((Object)calificaciones);
        }
        catch (Exception e) {
            log.error("Error al obtener las calificaciones: ", (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Collections.emptyList());
        }
    }

    public void saveCalificacion(Calificacion calificacion) {
        try {
            if (calificacion.getCalificacion().isEmpty()) {
                log.info("Error al guardar la informacion");
            }
            this.calificacionDAO.save((Object)calificacion);
        }
        catch (Exception e) {
            log.info("Error al guardar la calificacion" + e.getMessage());
        }
    }
}

