/*
 * Decompiled with CFR 0.152.
 */
package com.ganansol.logic.service.impl;

import com.ganansol.feignClient.models.ProcesoDTO;
import com.ganansol.feignClient.service.LhiaTrainService;
import com.ganansol.logic.model.CalificacionPregunta;
import com.ganansol.logic.model.Conversacion;
import com.ganansol.logic.repository.CalificacionPreguntasDAO;
import com.ganansol.logic.repository.ConversacionDAO;
import com.ganansol.logic.service.AuthenticationService;
import com.ganansol.logic.service.CalificacionPreguntaService;
import com.ganansol.utils.UtilLhia;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class CalificacionPreguntaServiceImpl
implements CalificacionPreguntaService {
    private static final Logger log = LoggerFactory.getLogger(CalificacionPreguntaServiceImpl.class);
    @Autowired
    private ConversacionDAO conversacionDAO;
    @Autowired
    private CalificacionPreguntasDAO calificacionPreguntaDAO;
    @Autowired
    private LhiaTrainService trainingService;
    @Autowired
    private AuthenticationService authService;

    public ResponseEntity<?> guardarCalificacion(String identificador, String calificacion, String pregunta, String respuesta, String respuestaEsperada) {
        Optional idConversacion = this.conversacionDAO.findIdConversationByUser(identificador);
        if (idConversacion.isPresent()) {
            CalificacionPregunta calificacionModel = new CalificacionPregunta();
            calificacionModel.setId_conversacion(new Conversacion(((Long)idConversacion.get()).longValue()));
            calificacionModel.setCalificacion(calificacion);
            calificacionModel.setFecha(UtilLhia.fechaEcuador());
            calificacionModel.setPregunta(pregunta.isEmpty() ? "respuesta pregunta anterior" : pregunta);
            calificacionModel.setRespuesta(respuesta);
            calificacionModel.setCalificacion_actualizada(calificacion);
            if (calificacion.toUpperCase().contains("BUENA")) {
                calificacionModel.setEnviado(Boolean.valueOf(true));
                this.sendQualifyToLhiaTrain(identificador, calificacion, pregunta, respuesta, true);
            } else {
                calificacionModel.setEnviado(Boolean.valueOf(false));
                this.sendQualifyToLhiaTrain(identificador, calificacion, pregunta, respuesta, false);
            }
            return ResponseEntity.ok((Object)((CalificacionPregunta)this.calificacionPreguntaDAO.save((Object)calificacionModel)));
        }
        return ResponseEntity.badRequest().build();
    }

    @Async
    protected void sendQualifyToLhiaTrain(String usuario, String calificacion, String pregunta, String respuesta, boolean esCorrecto) {
        ProcesoDTO proceso = new ProcesoDTO(pregunta, usuario, respuesta, Boolean.valueOf(esCorrecto), "TRANSACCIONAL", "procesos@ganansol.fin.ec");
        try {
            ResponseEntity response = this.trainingService.crearNuevoProcesoBotpress(proceso);
            log.info("Response: " + response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ResponseEntity<?> guardarCalificacionByUser(String usuario, String calificacion, String pregunta, String respuesta, String respuestaEsperada) {
        Optional idConversacion = this.conversacionDAO.findConversationByUser(usuario);
        if (idConversacion.isPresent()) {
            CalificacionPregunta calificacionModel = new CalificacionPregunta();
            calificacionModel.setId_conversacion(new Conversacion(((Long)idConversacion.get()).longValue()));
            calificacionModel.setCalificacion(calificacion);
            calificacionModel.setFecha(UtilLhia.fechaEcuador());
            calificacionModel.setPregunta(pregunta.isEmpty() ? "respuesta pregunta anterior" : pregunta);
            calificacionModel.setRespuesta(respuesta);
            calificacionModel.setCalificacion_actualizada(calificacion);
            if (calificacion.toUpperCase().contains("BUENA")) {
                calificacionModel.setEnviado(Boolean.valueOf(true));
                this.sendQualifyToLhiaTrain(usuario, calificacion, pregunta, respuesta, true);
            } else {
                calificacionModel.setEnviado(Boolean.valueOf(false));
                this.sendQualifyToLhiaTrain(usuario, calificacion, pregunta, respuesta, false);
            }
            return ResponseEntity.ok((Object)((CalificacionPregunta)this.calificacionPreguntaDAO.save((Object)calificacionModel)));
        }
        return ResponseEntity.badRequest().build();
    }
}

