/*
 * Decompiled with CFR 0.152.
 */
package com.ganansol.logic.service.impl;

import com.ganansol.logic.model.AuditAuth;
import com.ganansol.logic.repository.AuditAuthDAO;
import com.ganansol.logic.service.AuditAuthService;
import com.ganansol.utils.DateUtils;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class AuditAuthServiceImpl
implements AuditAuthService {
    private static final Logger log = LoggerFactory.getLogger(AuditAuthServiceImpl.class);
    @Autowired
    private AuditAuthDAO auditableDAO;

    public void saveAuditable(AuditAuth auditable) {
        AuditAuth audit = new AuditAuth();
        try {
            audit = new AuditAuth(auditable.getAccion(), auditable.getIpPublica(), auditable.getNombreUsuario(), auditable.getCedulaUsuario(), auditable.getEnvioSms(), auditable.getEnvioMail(), auditable.getOtp(), auditable.getRespuesta());
            this.auditableDAO.save((Object)audit);
        }
        catch (Exception e) {
            System.out.println("informacion no procesada" + e.getMessage());
        }
    }

    public void getAllRegisters() {
    }

    public ResponseEntity<?> getSolicitudes(String fecha1, String fecha2) {
        try {
            LocalDateTime date1 = DateUtils.parseStringToLocalDateTime((String)fecha1);
            LocalDateTime date2 = DateUtils.parseStringToLocalDateTime((String)fecha2);
            List solicitudes = this.auditableDAO.findSolictudesTransaccional(date1, date2);
            log.info("mostrando respuesta de codigo: " + solicitudes);
            return ResponseEntity.ok((Object)solicitudes);
        }
        catch (Exception e) {
            log.error("Error al obtener las solicitudes: ", (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Collections.emptyList());
        }
    }
}

