/*
 * Decompiled with CFR 0.152.
 */
package com.ganansol.logic.service.impl;

import com.ganansol.feignClient.models.ProcesoDTO;
import com.ganansol.feignClient.service.LhiaTrainService;
import com.ganansol.logic.service.ConversacionService;
import com.knuddels.jtokkit.Encodings;
import com.knuddels.jtokkit.api.Encoding;
import com.knuddels.jtokkit.api.EncodingRegistry;
import com.knuddels.jtokkit.api.ModelType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class AsyncTasksService {
    private static final Logger log = LoggerFactory.getLogger(AsyncTasksService.class);
    @Autowired
    private ConversacionService conversacionDAO;
    private EncodingRegistry registry = Encodings.newLazyEncodingRegistry();
    private Encoding encoding = this.registry.getEncodingForModel(ModelType.CUSHMAN_CODEX);
    @Autowired
    private LhiaTrainService trainingService;

    @Async
    public void procesarConversacionAsync(String identificador, String usuario, String promptCompleto, String pregunta, String answer, String promptSugerencia, String documentVectorial) {
        try {
            this.conversacionDAO.guardarConversacion(identificador, usuario, "", "", 0.0, 0, "", "");
            this.conversacionDAO.guardarConversacion(identificador, usuario, "user", promptCompleto, 0.0, this.encoding.countTokens(promptCompleto), "", pregunta);
            this.conversacionDAO.guardarConversacion(identificador, usuario, "assistant", answer, 0.0, this.encoding.countTokens(answer), "", "");
            this.conversacionDAO.actividadConversacion(identificador, pregunta, answer, documentVectorial);
            ProcesoDTO proceso = new ProcesoDTO(pregunta, "", answer, Boolean.valueOf(false), "TRANSACCIONAL", "procesos@ganansol.fin.ec");
            try {
                ResponseEntity response = this.trainingService.crearNuevoProcesoBotpress(proceso);
                log.info("Response: " + response);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            log.error("ERROR AL GUARDAR WITH ANSWER", (Throwable)e);
        }
    }
}

