/*
 * Decompiled with CFR 0.152.
 */
package com.ganansol.logic.service.impl;

import com.ganansol.logic.data.TemasConsumo;
import com.ganansol.logic.model.Actividad;
import com.ganansol.logic.repository.ActividadDAO;
import com.ganansol.logic.service.ActividadService;
import com.ganansol.utils.DateUtils;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ActividadServiceImpl
implements ActividadService {
    @Autowired
    private ActividadDAO actividadDAO;

    public List<TemasConsumo> obtenerTemas(String fecha1, String fecha2, String rol) {
        LocalDateTime date1 = DateUtils.parseStringToLocalDateTime((String)fecha1);
        LocalDateTime date2 = DateUtils.parseStringToLocalDateTime((String)fecha2);
        return this.actividadDAO.listadoTemasFrecuencia(date1, date2, rol);
    }

    public void guardarConversacion(String pregunta, String idCarpeta, String idconversacion, String respuesta) {
    }

    public List<Actividad> listadoActividadCarpetas(Long id, String fecha1, String fecha2) {
        LocalDateTime date1 = DateUtils.parseStringToLocalDateTime((String)fecha1);
        LocalDateTime date2 = DateUtils.parseStringToLocalDateTime((String)fecha2);
        return this.actividadDAO.listadoActividadCarpetas(id, date1, date2);
    }

    public Page<Actividad> listadoPreguntaPaginado(String fecha1, String fecha2, Long id, int pagina, int filas) {
        LocalDateTime date1 = DateUtils.parseStringToLocalDateTime((String)fecha1);
        LocalDateTime date2 = DateUtils.parseStringToLocalDateTime((String)fecha2);
        PageRequest pageable = PageRequest.of((int)pagina, (int)filas);
        return this.actividadDAO.listadoActividadPage(date1, date2, id, (Pageable)pageable);
    }
}

