/*
 * Decompiled with CFR 0.152.
 */
package com.ganansol.logic.service;

import com.ganansol.logic.model.AuditAuth;
import com.ganansol.logic.service.AuditAuthService;
import java.util.Map;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class CoreService {
    private final WebClient webClient;
    private final AuditAuthService auditService;

    public CoreService(WebClient webClient, AuditAuthService auditService) {
        this.webClient = webClient;
        this.auditService = auditService;
    }

    public Mono<String> fetchData(String firstName, String identification, String ip, Long smsCode) {
        String funcion = "GET_OTP";
        return ((WebClient.RequestBodySpec)this.webClient.post().uri("/lhia-auth", new Object[0])).contentType(MediaType.APPLICATION_JSON).body(BodyInserters.fromValue(Map.of("func", funcion, "str_first_name", firstName, "str_identification", identification, "ip", ip, "sendSMS", smsCode))).retrieve().bodyToMono(String.class).flatMap(response -> {
            AuditAuth auditable = new AuditAuth(funcion, ip, firstName, identification, smsCode, Long.valueOf(0L), "0", response);
            return Mono.fromRunnable(() -> this.auditService.saveAuditable(auditable)).thenReturn(response);
        });
    }

    public Mono<String> fetchDataIvr(String identification, Long smsCode) {
        String funcion = "GET_OTP";
        return ((WebClient.RequestBodySpec)this.webClient.post().uri("/lhia-auth", new Object[0])).contentType(MediaType.APPLICATION_JSON).body(BodyInserters.fromValue(Map.of("func", funcion, "str_identification", identification, "sendSMS", smsCode))).retrieve().bodyToMono(String.class).flatMap(response -> {
            AuditAuth auditable = new AuditAuth(funcion, "0.0.0.0", "user", identification, smsCode, Long.valueOf(0L), "0", response);
            return Mono.fromRunnable(() -> this.auditService.saveAuditable(auditable)).thenReturn(response);
        });
    }

    public Mono<String> ValidateData(String firstName, String identification, String ip, String otp) {
        String funcion = "VALIDATE_OTP";
        return ((WebClient.RequestBodySpec)this.webClient.post().uri("/lhia-auth", new Object[0])).contentType(MediaType.APPLICATION_JSON).body(BodyInserters.fromValue(Map.of("func", funcion, "str_first_name", firstName, "str_identification", identification, "ip", ip, "otp", otp))).retrieve().bodyToMono(String.class).flatMap(response -> {
            AuditAuth auditable = new AuditAuth(funcion, ip, firstName, identification, Long.valueOf(0L), Long.valueOf(0L), otp, response);
            return Mono.fromRunnable(() -> this.auditService.saveAuditable(auditable)).thenReturn(response);
        });
    }

    public Mono<String> ValidateDataIvr(String identification, String otp) {
        String funcion = "VALIDATE_OTP";
        return ((WebClient.RequestBodySpec)this.webClient.post().uri("/lhia-auth", new Object[0])).contentType(MediaType.APPLICATION_JSON).body(BodyInserters.fromValue(Map.of("func", funcion, "str_identification", identification, "otp", otp))).retrieve().bodyToMono(String.class).flatMap(response -> {
            AuditAuth auditable = new AuditAuth(funcion, "0.0.0.0", "user", identification, Long.valueOf(0L), Long.valueOf(0L), otp, response);
            return Mono.fromRunnable(() -> this.auditService.saveAuditable(auditable)).thenReturn(response);
        });
    }

    public Mono<String> fetchConsolidate(String token, String firstName, String identification, String ip) {
        String funcion = "GET_CONSOLIDATE";
        token = token.trim().replace("token:", "").replace("\"", "");
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/lhia-connect", new Object[0])).contentType(MediaType.APPLICATION_JSON).header("Authorization", new String[]{"Bearer " + token})).body(BodyInserters.fromValue(Map.of("func", funcion))).retrieve().bodyToMono(String.class).flatMap(response -> {
            AuditAuth auditable = new AuditAuth(funcion, ip, firstName, identification, Long.valueOf(0L), Long.valueOf(0L), "", response);
            return Mono.fromRunnable(() -> this.auditService.saveAuditable(auditable)).thenReturn(response);
        });
    }

    public Mono<String> DisabledAccount(String token, String firstName, String identification, String ip) {
        String funcion = "DISABLE_USER";
        token = token.trim().replace("token:", "").replace("\"", "");
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/lhia-connect", new Object[0])).contentType(MediaType.APPLICATION_JSON).header("Authorization", new String[]{"Bearer " + token})).body(BodyInserters.fromValue(Map.of("func", funcion))).retrieve().bodyToMono(String.class).flatMap(response -> {
            AuditAuth auditable = new AuditAuth(funcion, ip, firstName, identification, Long.valueOf(0L), Long.valueOf(0L), "", response);
            return Mono.fromRunnable(() -> this.auditService.saveAuditable(auditable)).thenReturn(response);
        });
    }

    public Mono<String> viewMovements(String accNumber, String token, String firstName, String identification, String ip) {
        String funcion = "GET_LAST_MOVEMENTS";
        token = token.trim().replace("token:", "").replace("\"", "");
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/lhia-connect", new Object[0])).contentType(MediaType.APPLICATION_JSON).header("Authorization", new String[]{"Bearer " + token})).body(BodyInserters.fromValue(Map.of("func", funcion, "dataSend", Map.of("accNumber", accNumber)))).retrieve().bodyToMono(String.class).flatMap(response -> {
            AuditAuth auditable = new AuditAuth(funcion, ip, firstName, identification, Long.valueOf(0L), Long.valueOf(0L), "", response);
            return Mono.fromRunnable(() -> this.auditService.saveAuditable(auditable)).thenReturn(response);
        });
    }

    public Mono<String> getLoanDetails(String token, String secuencialPrestamo, String fechaInicial, String FechaFinal) {
        String funcion = "GET_LOANS_DETAIL_TABLE";
        token = token.trim().replace("token:", "").replace("\"", "");
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/lhia-connect", new Object[0])).contentType(MediaType.APPLICATION_JSON).header("Authorization", new String[]{"Bearer " + token})).body(BodyInserters.fromValue(Map.of("func", funcion, "dataSend", Map.of("SecuencialPrestamo", secuencialPrestamo, "FechaInicial", fechaInicial, "FechaFinal", FechaFinal)))).retrieve().bodyToMono(String.class).flatMap(response -> {
            AuditAuth auditable = new AuditAuth(funcion, "0.0.0.0", secuencialPrestamo, "000000000", Long.valueOf(0L), Long.valueOf(0L), "", response);
            return Mono.fromRunnable(() -> this.auditService.saveAuditable(auditable)).thenReturn(response);
        });
    }

    public Mono<String> getLoadProfileByDni(String token, String identification) {
        String funcion = "RETURN_DATA_PERSON_IDENTIFICATION";
        token = token.trim().replace("token:", "").replace("\"", "");
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/lhia-connect", new Object[0])).contentType(MediaType.APPLICATION_JSON).header("Authorization", new String[]{"Bearer " + token})).body(BodyInserters.fromValue(Map.of("func", funcion, "dataSend", Map.of("Identificacion", identification)))).retrieve().bodyToMono(String.class).flatMap(response -> {
            AuditAuth auditable = new AuditAuth(funcion, "0.0.0.0", "user", identification, Long.valueOf(0L), Long.valueOf(0L), "", response);
            return Mono.fromRunnable(() -> this.auditService.saveAuditable(auditable)).thenReturn(response);
        });
    }

    public WebClient getWebClient() {
        return this.webClient;
    }

    public AuditAuthService getAuditService() {
        return this.auditService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CoreService)) {
            return false;
        }
        CoreService other = (CoreService)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        WebClient this$webClient = this.getWebClient();
        WebClient other$webClient = other.getWebClient();
        if (this$webClient == null ? other$webClient != null : !this$webClient.equals(other$webClient)) {
            return false;
        }
        AuditAuthService this$auditService = this.getAuditService();
        AuditAuthService other$auditService = other.getAuditService();
        return !(this$auditService == null ? other$auditService != null : !this$auditService.equals(other$auditService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CoreService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WebClient $webClient = this.getWebClient();
        result = result * 59 + ($webClient == null ? 43 : $webClient.hashCode());
        AuditAuthService $auditService = this.getAuditService();
        result = result * 59 + ($auditService == null ? 43 : $auditService.hashCode());
        return result;
    }

    public String toString() {
        return "CoreService(webClient=" + this.getWebClient() + ", auditService=" + this.getAuditService() + ")";
    }
}

