/*
 * Decompiled with CFR 0.152.
 */
package com.ganansol.logic.repository;

import com.ganansol.logic.data.CalificacionConsumo;
import com.ganansol.logic.model.CalificacionPregunta;
import feign.Param;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

public interface CalificacionPreguntasDAO
extends JpaRepository<CalificacionPregunta, Long> {
    @Query(value="SELECT tca.calificacion_actualizada AS calificacion, \r\n       COUNT(tca.id_conversacion) AS frecuencia, \r\n       ROW_NUMBER() OVER(ORDER BY COUNT(tca.calificacion_actualizada)) AS id \r\nfrom lhia_ganansol.t_calificacion_preguntas tca\r\nJOIN lhia_ganansol.t_conversacion tco on cast(tca.id_conversacion as integer)  = tco.id_conversacion\r\nJOIN lhia_ganansol.t_roles tr ON tco.id_roles = tr.id_roles\r\nWHERE CAST(tr.descripcion AS TEXT) like '%' || :rol || '%' and tca.fecha >= :fecha1  and tca.enviado = :enviado  and calificacion_actualizada like '%' || :calificacion || '%'\r\nand tca.fecha <= :fecha2  GROUP BY tca.calificacion_actualizada HAVING COUNT(*) > 1 ORDER BY frecuencia asc ", nativeQuery=true)
    public List<CalificacionConsumo> listadoCalificacionFrecuencia(@Param(value="fecha1") LocalDateTime var1, @Param(value="fecha2") LocalDateTime var2, @Param(value="rol") String var3, @Param(value="ensviado") Boolean var4, @Param(value="calificacion") String var5);

    @Query(value="select c from CalificacionPregunta c where c.id_conversacion.idConversacion= :id_conversacion order by c.id_calificacion DESC")
    public List<CalificacionPregunta> listadoCalificacionConversacion(@Param(value="id_conversacion") Long var1);

    @Query(value="select c from CalificacionPregunta c where c.calificacion like '%MALA%' and c.fecha >= :fecha1 and c.fecha <= :fecha2 order by c.fecha DESC")
    public List<CalificacionPregunta> listadoCalificacionRespuestasMalas(@Param(value="fecha1") LocalDateTime var1, @Param(value="fecha2") LocalDateTime var2);
}

