/*
 * Decompiled with CFR 0.152.
 */
package com.ganansol.logic.controller;

import com.ganansol.logic.data.ClienteConsumo;
import com.ganansol.logic.data.ResponseRobotDocument;
import com.ganansol.logic.data.RespuestaRobot;
import com.ganansol.logic.model.RequestBodyChat;
import com.ganansol.logic.service.BaseService;
import com.ganansol.logic.service.SeccionDocumentoService;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ganansol"})
public class QuestionController {
    private static final Logger log = LoggerFactory.getLogger(QuestionController.class);
    @Autowired
    private BaseService ganansolRepository;
    @Autowired
    private SeccionDocumentoService seccionDocumentoService;

    @GetMapping(value={"/anonimo"})
    public String saludo1() {
        return "Hola anonimo";
    }

    @GetMapping(value={"/admin"})
    public String saludo2() {
        return "Hola admin";
    }

    @GetMapping(value={"/user"})
    public String saludo3() {
        return "Hola user";
    }

    @PostMapping(value={"/chat-ganansol"})
    @CrossOrigin
    @PreAuthorize(value="hasRole('user')")
    public ResponseRobotDocument getAnswer(@RequestBody RequestBodyChat cliente) {
        ResponseRobotDocument robot = this.ganansolRepository.findDocumentsByQuestion(cliente.getMessage(), cliente.getDescripcion(), cliente.getIdentificador(), cliente.getUsuario());
        return robot;
    }

    @PostMapping(value={"/questionV3"}, consumes={"application/json; charset=UTF-8"})
    @CrossOrigin
    @PreAuthorize(value="hasRole('user')")
    public RespuestaRobot getProductMilvus(@RequestBody ClienteConsumo cliente) {
        RespuestaRobot robot = new RespuestaRobot();
        String answer = this.ganansolRepository.preguntaMilvus(cliente.getQuestion(), cliente.getDescripcion(), cliente.getIdentificador(), cliente.getUsuario());
        robot.setRespuesta(answer);
        System.out.println("response");
        return robot;
    }

    @GetMapping(value={"/generaEmb"})
    @CrossOrigin
    public void generaEmb() {
        this.seccionDocumentoService.generateEmbeddingsForSections();
    }

    @PostMapping(value={"/questionV5"}, consumes={"application/json"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    @PreAuthorize(value="hasRole('user')")
    public CompletableFuture<RespuestaRobot> getProductMilvusColaborador(@RequestBody ClienteConsumo cliente) {
        return CompletableFuture.supplyAsync(() -> {
            RespuestaRobot robot = new RespuestaRobot();
            String answer = this.ganansolRepository.preguntaMilvus(cliente.getQuestion(), cliente.getDescripcion(), cliente.getIdentificador(), cliente.getUsuario(), cliente.getLstConversation());
            robot.setRespuesta(answer);
            return robot;
        });
    }
}

