/*
 * Decompiled with CFR 0.152.
 */
package com.ganansol.logic.controller;

import com.ganansol.logic.data.ActualizacionConsumo;
import com.ganansol.logic.data.CalificacionConsumo;
import com.ganansol.logic.data.Gobernanza;
import com.ganansol.logic.data.RolesPreguntas;
import com.ganansol.logic.data.TemasConsumo;
import com.ganansol.logic.data.UsuariosConsumo;
import com.ganansol.logic.model.Actividad;
import com.ganansol.logic.model.CalificacionPregunta;
import com.ganansol.logic.model.DatosEntrenados;
import com.ganansol.logic.model.Email;
import com.ganansol.logic.service.ActividadService;
import com.ganansol.logic.service.AuditAuthService;
import com.ganansol.logic.service.BaseService;
import com.ganansol.logic.service.CalificacionService;
import com.ganansol.logic.service.ConversacionService;
import com.ganansol.logic.service.DocumentoActualizacionService;
import com.ganansol.logic.service.EmailService;
import com.ganansol.logic.service.GobernanzaService;
import com.ganansol.logic.service.RolesService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"report"})
@CrossOrigin(value={"*"})
public class DashboardReportController {
    private static final Logger log = LoggerFactory.getLogger(DashboardReportController.class);
    @Autowired
    private BaseService ganansolRepository;
    @Autowired
    private CalificacionService calificacionDAO;
    @Autowired
    private RolesService rolesDAO;
    @Autowired
    private AuditAuthService auditDAO;
    @Autowired
    private ActividadService actividadDAO;
    @Autowired
    private EmailService emailDAO;
    @Autowired
    private ConversacionService conversacionDAO;
    @Autowired
    private DocumentoActualizacionService actualizacionDAO;
    @Autowired
    private GobernanzaService gobernanzaDAO;
    @Autowired
    private DocumentoActualizacionService documentoDAO;

    @PostMapping(value={"/generaNumTokens"})
    public void generaNumTokens() {
        this.ganansolRepository.generateNumTokens();
    }

    @PostMapping(value={"/conversacion/tokens"})
    public int obtenerTokens(@RequestParam String fecha1, @RequestParam String fecha2, @RequestParam String rol) {
        return this.ganansolRepository.obtenerTokens(fecha1, fecha2, rol);
    }

    @PostMapping(value={"/calificaciones"})
    public ResponseEntity<?> getCalificacionBuena(@RequestParam String fecha1, @RequestParam String fecha2, @RequestParam String rol) {
        return this.calificacionDAO.getCalificaciones(fecha1, fecha2, rol);
    }

    @PostMapping(value={"/temas"})
    public List<TemasConsumo> getTemas(@RequestParam String fecha1, @RequestParam String fecha2, @RequestParam String rol) {
        return this.actividadDAO.obtenerTemas(fecha1, fecha2, rol);
    }

    @PostMapping(value={"/solicitudesTransacction"})
    public ResponseEntity<?> getSolicitudes(@RequestParam String fecha1, @RequestParam String fecha2) {
        return this.auditDAO.getSolicitudes(fecha1, fecha2);
    }

    @PostMapping(value={"/preguntas"})
    public List<Actividad> listadoActividadCarpetas(@RequestParam Long id, String fecha1, String fecha2) {
        return this.actividadDAO.listadoActividadCarpetas(id, fecha1, fecha2);
    }

    @PostMapping(value={"/preguntas/paginado"})
    public Page<Actividad> listaPreguntasPaginado(@RequestParam String fecha1, @RequestParam String fecha2, @RequestParam Long id, @RequestParam int pagina, @RequestParam int filas) {
        return this.actividadDAO.listadoPreguntaPaginado(fecha1, fecha2, id, pagina, filas);
    }

    @PostMapping(value={"/emails"})
    public Page<Email> listaEmailsPaginado(@RequestParam String fecha1, @RequestParam String fecha2, @RequestParam int pagina, @RequestParam int filas) {
        return this.emailDAO.getAllEmails(fecha1, fecha2, pagina, filas);
    }

    @PostMapping(value={"/rol/total_preguntas"})
    public List<RolesPreguntas> obtenerNumeroPreguntasRol(@RequestParam String fecha1, String fecha2, String rol) {
        return this.rolesDAO.obtenerNumeroPreguntasRol(fecha1, fecha2, rol);
    }

    @PostMapping(value={"/rol/total_preguntas_no_rol"})
    public List<?> uso4rolLhia(@RequestParam String fecha1, @RequestParam String fecha2) {
        return this.rolesDAO.obtenerNumeroPreguntasNoRol(fecha1, fecha2);
    }

    @PostMapping(value={"/rol/usuarios"})
    public List<UsuariosConsumo> obtenerlistadoUsuarios(@RequestParam String fecha1, String fecha2) {
        return this.conversacionDAO.obtenerlistadoUsuarios(fecha1, fecha2);
    }

    @PostMapping(value={"/gobernanza"})
    public List<Gobernanza> obtenerGovernanza(@RequestParam String fecha1, String fecha2, String rol) {
        return this.gobernanzaDAO.obtenerGovernanza(fecha1, fecha2, rol);
    }

    @PostMapping(value={"/actualizaciones"})
    public List<ActualizacionConsumo> obtenerActualizaciones(@RequestParam String fecha1, String fecha2) {
        return this.actualizacionDAO.obtenerActualizaciones(fecha1, fecha2);
    }

    @PostMapping(value={"/calificaciones_malas"}, produces={"application/json"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    public List<CalificacionPregunta> obtenerCalificacionesMalas(@RequestParam String fecha1, String fecha2) {
        return this.gobernanzaDAO.obtenerCalificacionesRespuestasMalas(fecha1, fecha2);
    }

    @PostMapping(value={"/calificaciones_malas/envio"})
    public ResponseEntity<CalificacionPregunta> obtenerCalificacionesMalas(@RequestParam Long id) {
        return this.gobernanzaDAO.actualizarEnviadoCalificacionesMalas(id);
    }

    @PostMapping(value={"/calificaciones_respuesta_usuario"})
    public List<CalificacionConsumo> obtenerCalificacionesRespuestaUsuario(@RequestParam String fecha1, String fecha2, String rol) {
        return this.gobernanzaDAO.obtenerCalificacionesRespuestaUsuario(fecha1, fecha2, rol);
    }

    @PostMapping(value={"/documentos/datosEntrenados"}, produces={"application/json"})
    @CrossOrigin(origins={""}, allowedHeaders={""})
    public List<DatosEntrenados> obtenerDatosEntrenados() {
        return this.documentoDAO.getDocumentosEntrenados();
    }
}

