/*
 * Decompiled with CFR 0.152.
 */
package com.ganansol.logic.controller;

import com.ganansol.logic.dto.RequestAuth;
import com.ganansol.logic.dto.ResponseAuth;
import com.ganansol.logic.service.CoreService;
import java.util.Map;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@CrossOrigin(value={"*"})
@RestController
@RequestMapping(value={"coreganansol"})
public class CoreGanansolController {
    private final CoreService coreApiService;

    public CoreGanansolController(CoreService coreApiService) {
        this.coreApiService = coreApiService;
    }

    @PostMapping(value={"/Authorization-Bank"})
    public Mono<String> fetchFromExternalApi(@RequestBody RequestAuth requestAuth) {
        return this.coreApiService.fetchData(requestAuth.getFirstName(), requestAuth.getIdentification(), requestAuth.getIp(), requestAuth.getSmsCode());
    }

    @PostMapping(value={"/Validator-Bank"})
    public Mono<String> fetchFromExternMono(@RequestBody ResponseAuth requestAuth) {
        return this.coreApiService.ValidateData(requestAuth.getFirstName(), requestAuth.getIdentification(), requestAuth.getIp(), requestAuth.getOtp());
    }

    @PostMapping(value={"/Auth-Bank-Ivr"})
    public Mono<String> fetchFromExternalApiIVR(@RequestBody RequestAuth requestAuth) {
        return this.coreApiService.fetchDataIvr(requestAuth.getIdentification(), requestAuth.getSmsCode());
    }

    @PostMapping(value={"/Validator-Bank-Ivr"})
    public Mono<String> fetchFromExternMonoIvr(@RequestBody ResponseAuth requestAuth) {
        return this.coreApiService.ValidateDataIvr(requestAuth.getIdentification(), requestAuth.getOtp());
    }

    @PostMapping(value={"/consolidate-Account"})
    public Mono<String> fetchConsolidate(@RequestBody Map<String, String> body) {
        return this.coreApiService.fetchConsolidate(body.get("token"), body.get("firstName"), body.get("identification"), body.get("ip"));
    }

    @PostMapping(value={"/disabled-User"})
    public Mono<String> disabledUser(@RequestBody Map<String, String> body) {
        return this.coreApiService.DisabledAccount(body.get("token"), body.get("firstName"), body.get("identification"), body.get("ip"));
    }

    @PostMapping(value={"/get-movements"})
    public Mono<String> getMovements(@RequestBody Map<String, String> body) {
        return this.coreApiService.viewMovements(body.get("accNumber"), body.get("token"), body.get("firstName"), body.get("identification"), body.get("ip"));
    }

    @PostMapping(value={"/get-credits"})
    public Mono<String> getCredits(@RequestBody Map<String, String> body) {
        return this.coreApiService.getLoanDetails(body.get("token"), body.get("secuencialPrestamo"), body.get("FechaInicial"), body.get("FechaFinal"));
    }

    @PostMapping(value={"/get-profile-by-dni"})
    public Mono<String> getProfileByDni(@RequestBody Map<String, String> body) {
        return this.coreApiService.getLoadProfileByDni(body.get("token"), body.get("identification"));
    }
}

