/*
 * Decompiled with CFR 0.152.
 */
package com.ganansol.logic.controller;

import com.ganansol.logic.model.EnvioCorreo;
import com.ganansol.logic.service.BaseService;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"complements"})
@CrossOrigin(value={"*"})
public class ComplementsController {
    private static final Logger log = LoggerFactory.getLogger(ComplementsController.class);
    private static final String BASE_DIR = "/url";
    @Autowired
    private BaseService baseService;

    @GetMapping(value={"/{nombreImagen}"})
    public ResponseEntity<Resource> getImage(@PathVariable String nombreImagen) throws IOException {
        Path imagePath = Paths.get(BASE_DIR, new String[0]).resolve(nombreImagen);
        UrlResource resource = new UrlResource(imagePath.toUri());
        if (resource.exists() && resource.isReadable()) {
            HttpHeaders headers = new HttpHeaders();
            String[] filenameParts = nombreImagen.split("\\.");
            if (filenameParts.length > 1) {
                String fileExtension = filenameParts[filenameParts.length - 1].toLowerCase();
                HashMap<String, MediaType> extensionToMediaType = new HashMap<String, MediaType>();
                extensionToMediaType.put("jpg", MediaType.IMAGE_JPEG);
                extensionToMediaType.put("jpeg", MediaType.IMAGE_JPEG);
                extensionToMediaType.put("png", MediaType.IMAGE_PNG);
                extensionToMediaType.put("gif", MediaType.IMAGE_GIF);
                MediaType mediaType = extensionToMediaType.getOrDefault(fileExtension, MediaType.APPLICATION_OCTET_STREAM);
                headers.setContentType(mediaType);
            } else {
                headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            }
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)resource);
        }
        return ResponseEntity.notFound().build();
    }

    @PostMapping(value={"/generar_correo"})
    public ResponseEntity<?> consumeApiPython(@RequestBody EnvioCorreo variables) {
        try {
            log.info("Recibe las variables controlador {}", (Object)variables);
            String respuesta = this.baseService.solicitarCredito(variables.getQuestion(), variables.getNombre(), variables.getEmail());
            return ResponseEntity.ok((Object)respuesta);
        }
        catch (Exception e) {
            log.error("error de api", (Object)e.getMessage());
            return null;
        }
    }
}

