/*
 * Decompiled with CFR 0.152.
 */
package com.ganansol.logic.controller;

import com.ganansol.logic.model.Calificacion;
import com.ganansol.logic.service.CalificacionPreguntaService;
import com.ganansol.logic.service.CalificacionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"calificacion"})
@CrossOrigin(value={"*"})
public class CalificacionController {
    private static final Logger log = LoggerFactory.getLogger(CalificacionController.class);
    @Autowired
    private CalificacionService calificacionDAO;
    @Autowired
    private CalificacionPreguntaService calificacionPreguntaDAO;

    @PostMapping(value={"/generar_calificacion"})
    public ResponseEntity<?> consumeApiPython(@RequestBody Calificacion calificacion) {
        try {
            this.calificacionDAO.saveCalificacion(calificacion);
            return ResponseEntity.ok((Object)"correo generado");
        }
        catch (Exception e) {
            log.error("error de api", (Object)e.getMessage());
            return null;
        }
    }

    @PostMapping(value={"/servicio/calificacion"}, consumes={"application/x-www-form-urlencoded"})
    @PreAuthorize(value="hasRole('user')")
    public ResponseEntity<?> guardarCalificacion(@RequestParam String identificador, @RequestParam String calificacion, @RequestParam String pregunta, @RequestParam String respuesta, @RequestParam String respuestaEsperada) {
        return this.calificacionPreguntaDAO.guardarCalificacion(identificador, calificacion, pregunta, respuesta, respuestaEsperada);
    }

    @PostMapping(value={"/servicio/calificacionbyUser"}, consumes={"application/x-www-form-urlencoded"})
    @PreAuthorize(value="hasRole('user')")
    public ResponseEntity<?> guardarCalificacionbyUser(@RequestParam String usuario, @RequestParam String calificacion, @RequestParam String pregunta, @RequestParam String respuesta, @RequestParam String respuestaEsperada) {
        return this.calificacionPreguntaDAO.guardarCalificacion(usuario, calificacion, pregunta, respuesta, respuestaEsperada);
    }
}

