/*
 * Decompiled with CFR 0.152.
 */
package com.ganansol.interceptors;

import com.ganansol.exceptions.CustomException;
import com.ganansol.utils.ApiResponse;
import java.io.IOException;
import java.nio.file.Files;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
public class GlobalExceptionHandler {
    Logger log = Logger.getLogger(GlobalExceptionHandler.class.getName());

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ApiResponse<Object>> handleGlobalException(Exception ex, WebRequest request) {
        this.log.log(Level.SEVERE, "Error: ", ex);
        ApiResponse response = new ApiResponse(500, false, false, ex.getMessage(), null);
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={RuntimeException.class})
    public ResponseEntity<ApiResponse<Object>> handleGlobalException(RuntimeException ex, WebRequest request) {
        this.log.log(Level.SEVERE, "Error: ", ex);
        ApiResponse response = new ApiResponse(500, false, false, ex.getMessage(), null);
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={CustomException.class})
    public ResponseEntity<ApiResponse<Object>> handleGlobalException(CustomException ex, WebRequest request) {
        ApiResponse response = new ApiResponse(ex.getHttpStatus().value(), false, false, ex.getMessage(), null);
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public ResponseEntity<byte[]> handleNotFound(NoHandlerFoundException ex) throws IOException {
        ClassPathResource resource = new ClassPathResource("static/index.html");
        byte[] content = Files.readAllBytes(resource.getFile().toPath());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.TEXT_HTML);
        return new ResponseEntity((Object)content, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }
}

