/*
 * Decompiled with CFR 0.152.
 */
package com.ganansol.auth;

import com.ganansol.auth.AuthAccessDeniedHandler;
import com.ganansol.auth.CustomAuthenticationEntryPoint;
import com.ganansol.auth.JwtAuthConverter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManagerResolver;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.server.resource.authentication.JwtIssuerAuthenticationManagerResolver;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
public class WebSecurityConfig {
    public static final String ADMIN = "admin";
    public static final String USER = "user";
    private final JwtAuthConverter jwtAuthConverter;

    public WebSecurityConfig(JwtAuthConverter jwtAuthConverter) {
        this.jwtAuthConverter = jwtAuthConverter;
    }

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity http) throws Exception {
        JwtIssuerAuthenticationManagerResolver issuerResolver = new JwtIssuerAuthenticationManagerResolver(new String[]{"https://login.tws2.io/auth/realms/lhia", "https://login.tws2.io/auth/realms/Ganansol"});
        ((HttpSecurity)http.authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(HttpMethod.GET, new String[]{"/ja/anonimo/**"})).permitAll().requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher("/web-solbot/js/script_bot_ganansol.js")})).permitAll().requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher("/web-solbot/js/script_bot_informativo_ganansol.js")})).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/ja/user"})).hasAnyRole(new String[]{"ADMIN", "USER"}).requestMatchers(HttpMethod.POST, new String[]{"/ganansol"})).hasAnyRole(new String[]{"ADMIN", "USER"}).requestMatchers(HttpMethod.POST, new String[]{"/coreganansol"})).hasAnyRole(new String[]{"ADMIN", "USER"}).requestMatchers(HttpMethod.POST, new String[]{"/report/**"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/complements/**"})).permitAll().anyRequest()).authenticated()).exceptionHandling(exceptions -> exceptions.authenticationEntryPoint((AuthenticationEntryPoint)new CustomAuthenticationEntryPoint()).accessDeniedHandler((AccessDeniedHandler)new AuthAccessDeniedHandler())).oauth2ResourceServer(oauth2 -> oauth2.authenticationManagerResolver((AuthenticationManagerResolver)issuerResolver)).sessionManagement(session -> session.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).cors().and()).csrf().disable();
        return (SecurityFilterChain)http.build();
    }
}

