/*
 * Decompiled with CFR 0.152.
 */
package com.agrota.utils;

import com.agrota.logic.data.ConversacionUsuario;
import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.json.JSONArray;
import org.json.JSONObject;

public class UtilLhia {
    private Logger log = Logger.getLogger(UtilLhia.class.getName());

    public void mostrarLista(List<ConversacionUsuario> lstConversation) {
        this.log.info("------------------------------------------------------------------------");
        for (int i = 0; i < lstConversation.size(); ++i) {
            this.log.info("rol:" + lstConversation.get(i).getRole());
            this.log.info("mensaje:" + lstConversation.get(i).getContent());
            this.log.info("------------------------------------------------------------------------");
        }
        this.log.info("------------------------------------------------------------------------");
    }

    public String obtenerUltimaRespuesta(List<ConversacionUsuario> lstConversation) {
        String resp = "";
        for (int i = lstConversation.size() - 1; i > 0; --i) {
            if (!lstConversation.get(i).getRole().equals("assistant")) continue;
            resp = lstConversation.get(i).getContent();
            break;
        }
        return resp;
    }

    public static String truncar2Decimales(String dato) {
        double numero = Double.parseDouble(dato);
        return String.format("%.2f", numero).replace('.', ',');
    }

    public static String parseEmbedding(String response) {
        JSONObject jsonObject = new JSONObject(response);
        JSONArray jsonArray = jsonObject.getJSONArray("embedding");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < jsonArray.length(); ++i) {
            stringBuilder.append(jsonArray.getDouble(i));
            if (i == jsonArray.length() - 1) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    public double cosineSimilarity(String embedding1, String embedding2) {
        double[] arr1 = Stream.of(embedding1.split(",")).mapToDouble(Double::parseDouble).toArray();
        double[] arr2 = Stream.of(embedding2.split(",")).mapToDouble(Double::parseDouble).toArray();
        double dotProduct = 0.0;
        double norm1 = 0.0;
        double norm2 = 0.0;
        for (int i = 0; i < arr1.length; ++i) {
            dotProduct += arr1[i] * arr2[i];
            norm1 += Math.pow(arr1[i], 2.0);
            norm2 += Math.pow(arr2[i], 2.0);
        }
        if (norm1 == 0.0 || norm2 == 0.0) {
            return 0.0;
        }
        return dotProduct / (Math.sqrt(norm1) * Math.sqrt(norm2));
    }

    public static Date fechaEcuador() {
        LocalDateTime fechaHoraEcuador = LocalDateTime.now();
        return Date.from(fechaHoraEcuador.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static String fechaEcuadorFormateada() {
        LocalDate fecha = LocalDate.now(ZoneId.of("America/Guayaquil"));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        return fecha.format(formatter);
    }

    public String quitarTildes(String texto) {
        String textoNormalizado = Normalizer.normalize(texto, Normalizer.Form.NFD);
        String textoSinTildes = textoNormalizado.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "");
        String fraseFinal = textoSinTildes.replaceAll("\\?+", "");
        String fraseFinal1 = fraseFinal.replaceAll("\\n+", " ");
        String fraseFinal2 = fraseFinal1.replaceAll("\\(+", "");
        String fraseFinal3 = fraseFinal2.replaceAll("\\)+", "");
        String fraseFinal4 = fraseFinal3.replaceAll("\\-+", " ");
        String fraseFinal5 = fraseFinal4.replaceAll("\\:+", "");
        String fraseFinal6 = fraseFinal5.replaceAll("\\*+", "");
        String fraseFinal7 = fraseFinal6.replaceAll("\\.+", "");
        String fraseFinal8 = fraseFinal7.replaceAll("\\,+", "");
        String fraseFinal9 = fraseFinal8.replaceAll("\\\u00bf+", "");
        String fraseFinal10 = fraseFinal9.replaceAll("\\s+", " ");
        String fraseFinal11 = fraseFinal10.replaceAll("\\s{3,}", " ");
        String fraseFinal12 = fraseFinal11.replaceAll("\\/+", " ");
        String fraseFinal13 = fraseFinal12.replaceAll("-", " ");
        String fraseFinal14 = fraseFinal13.replace("*", "");
        String fraseFinal15 = fraseFinal14.replaceAll("\n", "");
        String fraseFinal16 = fraseFinal15.replaceAll("  ", " ");
        String fraseFinal17 = fraseFinal16.replaceAll("   ", " ");
        String fraseFinal18 = fraseFinal17.replaceAll("\u00ae", "");
        String fraseFinal19 = fraseFinal18.replaceAll("\u2122", "");
        return fraseFinal19;
    }

    public Date stringToDate(String fecha_string) throws Exception {
        SimpleDateFormat formato = new SimpleDateFormat("yyyy-MM-dd");
        Date fecha = formato.parse(fecha_string);
        System.out.println("Fecha convertida: " + fecha);
        return fecha;
    }
}

