/*
 * Decompiled with CFR 0.152.
 */
package com.agrota.logic.service.impl;

import com.agrota.logic.data.DataTest;
import com.agrota.logic.service.TestService;
import com.agrota.logic.service.impl.BaseServiceImpl;
import com.agrota.logic.service.impl.TestServiceImpl;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TestServiceImpl
implements TestService {
    @Autowired
    BaseServiceImpl base;

    private String obtenerValorCelda(Cell celda) {
        switch (1.$SwitchMap$org$apache$poi$ss$usermodel$CellType[celda.getCellType().ordinal()]) {
            case 1: {
                return celda.getStringCellValue();
            }
            case 2: {
                if (DateUtil.isCellDateFormatted((Cell)celda)) {
                    return celda.getDateCellValue().toString();
                }
                return Double.toString(celda.getNumericCellValue());
            }
            case 3: {
                return Boolean.toString(celda.getBooleanCellValue());
            }
            case 4: {
                return celda.getCellFormula();
            }
            case 5: {
                return "";
            }
        }
        return "Tipo de dato desconocido";
    }

    public byte[] generarNuevoArchivoExcel(List<DataTest> datos, String nombreArchivoOriginal) throws Exception {
        XSSFWorkbook nuevoWorkbook = new XSSFWorkbook();
        Sheet nuevaHoja = nuevoWorkbook.createSheet("Datos Procesados");
        Row encabezado = nuevaHoja.createRow(0);
        Cell encabezadoColumna1 = encabezado.createCell(0);
        encabezadoColumna1.setCellValue("Pregunta");
        Cell encabezadoColumna2 = encabezado.createCell(1);
        encabezadoColumna2.setCellValue("Respuesta");
        int filaNum = 1;
        for (DataTest dataRow : datos) {
            Row fila = nuevaHoja.createRow(filaNum);
            Cell celdaValor = fila.createCell(0);
            celdaValor.setCellValue(dataRow.getPregunta());
            Cell celdaNumeroFila = fila.createCell(1);
            celdaNumeroFila.setCellValue(dataRow.getRespuesta());
            ++filaNum;
        }
        nuevaHoja.autoSizeColumn(0);
        nuevaHoja.autoSizeColumn(1);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        nuevoWorkbook.write((OutputStream)bos);
        nuevoWorkbook.close();
        return bos.toByteArray();
    }
}

