/*
 * Decompiled with CFR 0.152.
 */
package com.agrota.logic.service.impl;

import com.agrota.logic.model.SeccionDocumento;
import com.agrota.logic.repository.SeccionDocumentoDAO;
import com.agrota.logic.service.SeccionDocumentoService;
import com.agrota.utils.UtilLhia;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class SeccionDocumentoServiceImpl
implements SeccionDocumentoService {
    private static final Logger log = LoggerFactory.getLogger(SeccionDocumentoServiceImpl.class);
    @Value(value="${openai.apiKey}")
    private String apiKey;
    @Value(value="${openai.url}")
    private String url;
    @Autowired
    private SeccionDocumentoDAO seccionDAO;
    UtilLhia util = new UtilLhia();

    public List<SeccionDocumento> getPromptsByRole(String role) {
        log.info("OBTENIENDO LAS SECCIONDES DEL DOCUMENTO");
        return this.seccionDAO.findAllSectionsByRole(role);
    }

    public void generateEmbeddingsForSections() {
        List lstSeccion = this.seccionDAO.listadoProductosNG();
        for (SeccionDocumento seccion : lstSeccion) {
            String prompt = seccion.getTexto();
            String response = this.generateEmbedding(this.util.quitarTildes(prompt.toLowerCase()));
            System.out.println("\n" + this.util.quitarTildes(prompt.toLowerCase()));
            seccion.setEmbedding(response);
            seccion.setGenerado(Long.valueOf(1L));
            this.seccionDAO.save((Object)seccion);
        }
    }

    public String generateEmbedding(String prompt) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("input", (Object)prompt);
        jsonObject.put("model", (Object)"text-embedding-3-large");
        jsonObject.put("dimensions", 3072);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity requestEntity = new HttpEntity((Object)jsonObject.toString(), (MultiValueMap)headers);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity responseEntity = restTemplate.exchange(this.url, HttpMethod.POST, requestEntity, String.class, new Object[0]);
        JSONObject responseJson = new JSONObject((String)responseEntity.getBody());
        JSONArray embeddingArray = responseJson.getJSONArray("data");
        String embedding = embeddingArray.join("embedding");
        return UtilLhia.parseEmbedding((String)embedding);
    }
}

