/*
 * Decompiled with CFR 0.152.
 */
package com.agrota.logic.service.impl;

import com.agrota.logic.data.ClienteVendedor;
import com.agrota.logic.data.Empleado;
import com.agrota.logic.dto.DetalleOrdenPedidoResponse;
import com.agrota.logic.dto.DetallePedidoProducto;
import com.agrota.logic.dto.EstadoEntregaDto;
import com.agrota.logic.service.BaseService;
import com.agrota.logic.service.MilvusService;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.ProtocolStringList;
import io.milvus.client.MilvusServiceClient;
import io.milvus.grpc.DataType;
import io.milvus.grpc.FieldData;
import io.milvus.grpc.QueryResults;
import io.milvus.grpc.ShowCollectionsResponse;
import io.milvus.param.ConnectParam;
import io.milvus.param.IndexType;
import io.milvus.param.MetricType;
import io.milvus.param.R;
import io.milvus.param.collection.CreateCollectionParam;
import io.milvus.param.collection.DropCollectionParam;
import io.milvus.param.collection.FieldType;
import io.milvus.param.collection.HasCollectionParam;
import io.milvus.param.collection.LoadCollectionParam;
import io.milvus.param.collection.ReleaseCollectionParam;
import io.milvus.param.collection.ShowCollectionsParam;
import io.milvus.param.dml.InsertParam;
import io.milvus.param.dml.QueryParam;
import io.milvus.param.index.CreateIndexParam;
import io.milvus.param.index.DropIndexParam;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MilvusServiceImpl
implements MilvusService {
    private static final Logger log = LoggerFactory.getLogger(MilvusServiceImpl.class);
    private final RestTemplate restTemplate = new RestTemplate();
    MilvusServiceClient milvusClient = new MilvusServiceClient(ConnectParam.newBuilder().withHost("74.208.60.79").withPort(19530).withDatabaseName("agrotaPedidos").build());
    private final ExecutorService executorService = Executors.newFixedThreadPool(20);
    private static final int MAX_TEXTO = 65000;
    @Autowired
    private BaseService baseService;

    private List<String> construirChunksCliente(String nombreCliente, String identificacionCliente, List<EstadoEntregaDto> pedidos, HttpHeaders headers) {
        ClienteVendedor cvLite = new ClienteVendedor();
        cvLite.setNombreApellidoNombreComercial(MilvusServiceImpl.hasText((String)nombreCliente) ? nombreCliente : "CLIENTE SIN NOMBRE");
        cvLite.setNumeroIdentificacionCliente(MilvusServiceImpl.hasText((String)identificacionCliente) ? identificacionCliente : "N/A");
        return this.construirChunksCliente(cvLite, pedidos, headers);
    }

    /*
     * WARNING - void declaration
     */
    private List<String> construirChunksCliente(ClienteVendedor cv, List<EstadoEntregaDto> pedidos, HttpHeaders headers) {
        String ln = System.lineSeparator();
        ArrayList<String> bloquesPedido = new ArrayList<String>();
        for (EstadoEntregaDto e : pedidos) {
            String resumen = this.construirResumenPedido(e);
            String productos = this.construirLineaProductos(e.getNumeroOrdenPedido(), headers, new ConcurrentHashMap());
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("- ").append(resumen);
            if (MilvusServiceImpl.hasText((String)productos)) {
                stringBuilder.append(" Productos: ").append(productos);
            }
            stringBuilder.append(ln);
            bloquesPedido.add(stringBuilder.toString());
        }
        ArrayList<String> filas = new ArrayList<String>();
        StringBuilder actual = new StringBuilder();
        int cabeceraLen = actual.length();
        for (String string : bloquesPedido) {
            void var10_15;
            int espacioConCabecera = 65000 - cabeceraLen;
            if (string.length() > espacioConCabecera) {
                int permitido = Math.max(2000, espacioConCabecera - 100);
                String string2 = string.substring(0, Math.min(permitido, string.length())) + " ... [pedido compactado]";
            }
            if (actual.length() + var10_15.length() > 65000) {
                filas.add(actual.toString());
                actual = new StringBuilder().append((String)var10_15);
                continue;
            }
            actual.append((String)var10_15);
        }
        if (actual.length() > cabeceraLen) {
            filas.add(actual.toString());
        }
        return filas;
    }

    private List<EstadoEntregaDto> consultarEstadoEntrega(String codigoVendedor, String codigoCliente, HttpHeaders headers) {
        UriComponentsBuilder ub = UriComponentsBuilder.fromHttpUrl((String)"https://felizia-api.lhia.ai/api/EstadoOrden/estadoEntrega");
        if (MilvusServiceImpl.hasText((String)codigoVendedor)) {
            ub.queryParam("vendedor", new Object[]{codigoVendedor});
        }
        if (MilvusServiceImpl.hasText((String)codigoCliente)) {
            ub.queryParam("cliente", new Object[]{codigoCliente});
        }
        ResponseEntity resp = this.restTemplate.exchange(ub.toUriString(), HttpMethod.GET, new HttpEntity((MultiValueMap)headers), String.class, new Object[0]);
        try {
            ObjectMapper mapper = new ObjectMapper();
            List todos = (List)mapper.readValue((String)resp.getBody(), (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, EstadoEntregaDto.class));
            return todos.stream().filter(e -> MilvusServiceImpl.isNumeroOrdenValido((String)e.getNumeroOrdenPedido())).filter(e -> !MilvusServiceImpl.hasText((String)codigoCliente) || codigoCliente.equals(MilvusServiceImpl.safe((String)e.getClienteOrdenPedido()))).toList();
        }
        catch (Exception e2) {
            throw new RuntimeException("Error parseando estadoEntrega", e2);
        }
    }

    public void subirTodosLosPedidosMilvus() {
        HttpHeaders headers = this.crearHeaders();
        List empleados = this.consultarEmpleados(headers);
        ArrayList<CompletionStage> tareas = new ArrayList<CompletionStage>();
        for (Empleado emp : empleados) {
            tareas.add(CompletableFuture.runAsync(() -> this.procesarVendedor(emp, headers), this.executorService).exceptionally(ex -> {
                log.error("Error en vendedor {}: {}", (Object)emp.getNombreUsuarioEmpleado(), (Object)ex.getMessage());
                return null;
            }));
        }
        CompletableFuture.allOf(tareas.toArray(new CompletableFuture[0])).join();
        log.info("\ud83d\ude80 Proceso completado para {} vendedores.", (Object)empleados.size());
    }

    private void procesarVendedor(Empleado emp, HttpHeaders headers) {
        String usuario = emp.getNombreUsuarioEmpleado();
        String codVendedor = emp.getCodigoEmpleado();
        String coleccionMilvus = this.normalizarNombre(usuario);
        log.info("\ud83d\udd39 Procesando vendedor {} ({}) -> {}", new Object[]{usuario, codVendedor, coleccionMilvus});
        this.crearColeccionSiNoExiste(coleccionMilvus);
        List clientes = this.consultarClientesPorUsuario(usuario, headers);
        if (clientes == null || clientes.isEmpty()) {
            log.warn("\u26a0 No hay clientes para vendedor {}", (Object)usuario);
            return;
        }
        int totalClientes = clientes.size();
        int clientesConPedidos = 0;
        int filasInsertadas = 0;
        for (ClienteVendedor cv : clientes) {
            String codigoCliente = cv.getCodigo_cliente();
            String identificacionCliente = cv.getNumeroIdentificacionCliente();
            String nombreCliente = cv.getNombreApellidoNombreComercial();
            try {
                log.info("   \ud83d\udd0d Cliente {} - {}", (Object)codigoCliente, (Object)nombreCliente);
                List<EstadoEntregaDto> pedidosCliente = this.consultarEstadoEntrega(codVendedor, codigoCliente, headers);
                if (pedidosCliente == null || pedidosCliente.isEmpty()) {
                    log.info("   \u274c Cliente {} SIN pedidos", (Object)codigoCliente);
                    continue;
                }
                log.info("   \ud83d\udce6 Cliente {} tiene {} pedidos antes de filtro 3 meses", (Object)codigoCliente, (Object)pedidosCliente.size());
                pedidosCliente = pedidosCliente.stream().filter(e -> this.esDeUltimos3Meses(e.getFechaOrdenPedido())).toList();
                if (pedidosCliente.isEmpty()) {
                    log.info("   \u274c Cliente {} sin pedidos recientes (\u00faltimos 3 meses)", (Object)codigoCliente);
                    continue;
                }
                log.info("   \u2705 Cliente {} tiene {} pedidos recientes", (Object)codigoCliente, (Object)pedidosCliente.size());
                List ultimos = this.ultimosPorPedidoSoloSecuencia(pedidosCliente);
                if (ultimos.isEmpty()) {
                    log.info("   \u26a0 Cliente {} sin \u00faltimos estados por pedido", (Object)codigoCliente);
                    continue;
                }
                List filasTexto = this.construirChunksCliente(cv, ultimos, headers);
                if (filasTexto == null || filasTexto.isEmpty()) {
                    log.info("   \u26a0 Cliente {} gener\u00f3 0 filas de texto", (Object)codigoCliente);
                    continue;
                }
                ++clientesConPedidos;
                for (String textoFila : filasTexto) {
                    List vector = this.generarEmbeddingDummy(3072);
                    this.insertarEnMilvus(coleccionMilvus, nombreCliente + " ID: " + identificacionCliente, textoFila, vector);
                    ++filasInsertadas;
                }
                log.info("   \ud83d\udcbe Cliente {} insert\u00f3 {} filas en Milvus", (Object)codigoCliente, (Object)filasTexto.size());
            }
            catch (Exception ex) {
                log.error("   \u274c Error procesando cliente {} - {}: {}", new Object[]{codigoCliente, nombreCliente, ex.getMessage(), ex});
            }
        }
        log.info("\u2705 Finalizado vendedor {}. Clientes totales: {}, con pedidos: {}, filas insertadas en Milvus: {}", new Object[]{usuario, totalClientes, clientesConPedidos, filasInsertadas});
    }

    private List<Float> generarEmbeddingDummy(int dimension) {
        Random random = new Random();
        ArrayList<Float> vector = new ArrayList<Float>(dimension);
        for (int i = 0; i < dimension; ++i) {
            vector.add(Float.valueOf(random.nextFloat() * 2.0f - 1.0f));
        }
        return vector;
    }

    public List<ClienteVendedor> consultarClientesPorUsuario(String nombreUsuarioEmpleado, HttpHeaders headers) {
        try {
            UriComponentsBuilder ub = UriComponentsBuilder.fromHttpUrl((String)"https://felizia-api.lhia.ai/api/ClienteVendedor/byPalabra/{NombreUsuarioEmpleado}").queryParam("NombreApellidoNombreComercial", new Object[]{"%"});
            String url = ub.encode().buildAndExpand(new Object[]{nombreUsuarioEmpleado}).toUriString();
            ResponseEntity resp = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), String.class, new Object[0]);
            if (!resp.getStatusCode().is2xxSuccessful() || resp.getBody() == null || ((String)resp.getBody()).isBlank()) {
                log.warn("consultarClientesPorUsuario: respuesta vac\u00eda para usuario {}", (Object)nombreUsuarioEmpleado);
                return List.of();
            }
            ObjectMapper om = new ObjectMapper();
            return (List)om.readValue((String)resp.getBody(), (JavaType)om.getTypeFactory().constructCollectionType(List.class, ClienteVendedor.class));
        }
        catch (Exception e) {
            log.error("Error consultando clientes para usuario {}: {}", (Object)nombreUsuarioEmpleado, (Object)e.getMessage());
            return List.of();
        }
    }

    private List<Empleado> consultarEmpleados(HttpHeaders headers) {
        ResponseEntity response = this.restTemplate.exchange("https://felizia-api.lhia.ai/api/Empleado", HttpMethod.GET, new HttpEntity((MultiValueMap)headers), String.class, new Object[0]);
        try {
            ObjectMapper om = new ObjectMapper();
            return (List)om.readValue((String)response.getBody(), (JavaType)om.getTypeFactory().constructCollectionType(List.class, Empleado.class));
        }
        catch (Exception e) {
            throw new RuntimeException("Error al consultar empleados", e);
        }
    }

    private void crearColeccionSiNoExiste(String nombre) {
        boolean existe = (Boolean)this.milvusClient.hasCollection(HasCollectionParam.newBuilder().withCollectionName(nombre).build()).getData();
        if (!existe) {
            CreateCollectionParam param = CreateCollectionParam.newBuilder().withCollectionName(nombre).withDescription("Pedidos del usuario " + nombre).withShardsNum(2).addFieldType(FieldType.newBuilder().withName("id").withDataType(DataType.Int64).withPrimaryKey(true).withAutoID(true).build()).addFieldType(FieldType.newBuilder().withName("cliente").withDataType(DataType.VarChar).withMaxLength(Integer.valueOf(256)).build()).addFieldType(FieldType.newBuilder().withName("texto").withDataType(DataType.VarChar).withMaxLength(Integer.valueOf(65535)).build()).addFieldType(FieldType.newBuilder().withName("vector").withDataType(DataType.FloatVector).withDimension(Integer.valueOf(3072)).build()).build();
            this.milvusClient.createCollection(param);
        }
        try {
            CreateIndexParam index = CreateIndexParam.newBuilder().withCollectionName(nombre).withFieldName("vector").withIndexType(IndexType.IVF_FLAT).withMetricType(MetricType.COSINE).withExtraParam("{\"nlist\":36}").withSyncMode(Boolean.TRUE).build();
            this.milvusClient.createIndex(index);
        }
        catch (Exception e) {
            log.warn("No se pudo describir/crear \u00edndice en {}: {}", (Object)nombre, (Object)e.getMessage());
        }
        this.milvusClient.loadCollection(LoadCollectionParam.newBuilder().withCollectionName(nombre).build());
    }

    private void insertarEnMilvus(String coleccion, String cliente, String texto, List<Float> embedding) {
        List<InsertParam.Field> fields = List.of(new InsertParam.Field("cliente", List.of(cliente)), new InsertParam.Field("texto", List.of(texto)), new InsertParam.Field("vector", List.of(embedding)));
        InsertParam insertParam = InsertParam.newBuilder().withCollectionName(coleccion).withFields(fields).build();
        this.milvusClient.insert(insertParam);
    }

    private String normalizarNombre(String raw) {
        return raw.toLowerCase().replaceAll("[^a-z0-9_]+", "_").replaceAll("__+", "_").replaceAll("^_|_$", "");
    }

    private List<DetallePedidoProducto> consultarDetalleOrden(String numeroOrdenPedidoCabecera, HttpHeaders headers) {
        if (!MilvusServiceImpl.isNumeroOrdenValido((String)numeroOrdenPedidoCabecera)) {
            return List.of();
        }
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)"https://felizia-api.lhia.ai/api/EstadoOrden/detalleOrden").queryParam("numeroOrdenPedidoCabecera", new Object[]{numeroOrdenPedidoCabecera});
        ResponseEntity resp = this.restTemplate.exchange(builder.toUriString(), HttpMethod.GET, new HttpEntity((MultiValueMap)headers), String.class, new Object[0]);
        if (resp.getStatusCode().is2xxSuccessful() && resp.getBody() != null && !((String)resp.getBody()).isBlank()) {
            try {
                ObjectMapper om = new ObjectMapper();
                List filas = (List)om.readValue((String)resp.getBody(), (JavaType)om.getTypeFactory().constructCollectionType(List.class, DetalleOrdenPedidoResponse.class));
                if (filas == null || filas.isEmpty()) {
                    return List.of();
                }
                return filas.stream().filter(f -> f.getDetalleProductos() != null).flatMap(f -> f.getDetalleProductos().stream()).collect(Collectors.toList());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return List.of();
    }

    private HttpHeaders crearHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.set("accept", "*/*");
        headers.set("Authorization", "Bearer " + this.baseService.obtenerToken());
        return headers;
    }

    private String normalizarDescripcionEstadoOrden(String original) {
        if (!MilvusServiceImpl.hasText((String)original)) {
            return original;
        }
        String texto = original.trim();
        String upper = texto.toUpperCase(Locale.ROOT);
        if (upper.contains("FACTURADO PARCIAL") || upper.contains("FACTURA PARCIAL")) {
            return "FACTURADO (P)";
        }
        return texto;
    }

    private String construirResumenPedido(EstadoEntregaDto e) {
        String fechaFormateada;
        DateTimeFormatter formatter;
        LocalDateTime fecha2;
        StringBuilder r = new StringBuilder();
        r.append("Orden o pedido ").append(MilvusServiceImpl.safe((String)e.getNumeroOrdenPedido())).append(", ");
        if (MilvusServiceImpl.hasText((String)e.getDescripcionEstadoOrden())) {
            String descNormalizada = this.normalizarDescripcionEstadoOrden(e.getDescripcionEstadoOrden());
            r.append("Estado orden: ").append(descNormalizada).append(", ");
        }
        if (MilvusServiceImpl.hasText((String)e.getEstadoOrdenEnvio())) {
            r.append("Estado orden env\u00edo: ").append(e.getEstadoOrdenEnvio().trim()).append(", ");
        }
        if (MilvusServiceImpl.hasText((String)e.getNoFactura())) {
            r.append("Factura: ").append(e.getNoFactura().trim()).append(", ");
        } else {
            r.append("Factura: Sin facturar a\u00fan. ");
        }
        if (MilvusServiceImpl.hasText((String)e.getProveedorEnvio())) {
            r.append("Proveedor env\u00edo: ").append(e.getProveedorEnvio().trim()).append(", ");
        }
        if (MilvusServiceImpl.hasText((String)e.getDescripcionEstadoEnvio())) {
            r.append("Estado  env\u00edo: ").append(e.getDescripcionEstadoEnvio().trim()).append(", ");
        }
        if (MilvusServiceImpl.hasText((String)e.getFechaOrdenPedido())) {
            try {
                fecha2 = LocalDateTime.parse(e.getFechaOrdenPedido().replace(" ", ""));
                formatter = DateTimeFormatter.ofPattern("d - MMMM - yyyy", new Locale("es", "ES"));
                fechaFormateada = fecha2.format(formatter);
                r.append("Fecha pedido: ").append(fechaFormateada).append(", ");
            }
            catch (Exception fecha2) {
                // empty catch block
            }
        }
        if (MilvusServiceImpl.hasText((String)e.getDescripcionParcialGenerado())) {
            r.append("Numero parcial orden o pedido: ").append(e.getDescripcionParcialGenerado().trim()).append(", ");
        }
        if (MilvusServiceImpl.hasText((String)e.getNoGuiaEnvio())) {
            r.append("Gu\u00eda: ").append(e.getNoGuiaEnvio().trim()).append(", ");
        }
        if (MilvusServiceImpl.hasText((String)e.getFechaTrackingEnvio())) {
            try {
                fecha2 = LocalDateTime.parse(e.getFechaTrackingEnvio().replace(" ", ""));
                formatter = DateTimeFormatter.ofPattern("d - MMMM - yyyy", new Locale("es", "ES"));
                fechaFormateada = fecha2.format(formatter);
                r.append("Fecha env\u00edo: ").append(fechaFormateada).append(", ");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return r.toString().trim();
    }

    private List<EstadoEntregaDto> ultimosPorPedidoSoloSecuencia(List<EstadoEntregaDto> items) {
        if (items == null || items.isEmpty()) {
            return List.of();
        }
        Map grupos = items.stream().filter(e -> e != null && MilvusServiceImpl.isNumeroOrdenValido((String)e.getNumeroOrdenPedido())).collect(Collectors.groupingBy(EstadoEntregaDto::getNumeroOrdenPedido, LinkedHashMap::new, Collectors.toList()));
        ArrayList<EstadoEntregaDto> elegidos = new ArrayList<EstadoEntregaDto>();
        for (Map.Entry entry : grupos.entrySet()) {
            List g = (List)entry.getValue();
            Optional<EstadoEntregaDto> conSecMax = g.stream().filter(x -> MilvusServiceImpl.parseIntSafe((String)x.getOrdenSecuenciaEnvio()) != null).max(Comparator.comparing(x -> MilvusServiceImpl.parseIntSafe((String)x.getOrdenSecuenciaEnvio())));
            if (conSecMax.isPresent()) {
                elegidos.add(conSecMax.get());
                continue;
            }
            EstadoEntregaDto masInformativo = g.stream().max(Comparator.comparingInt(arg_0 -> this.scoreInformacion(arg_0)).thenComparingInt(x -> 0)).orElse((EstadoEntregaDto)g.get(0));
            elegidos.add(masInformativo);
        }
        return elegidos.stream().sorted(Comparator.comparing(EstadoEntregaDto::getNumeroOrdenPedido)).toList();
    }

    private int scoreInformacion(EstadoEntregaDto e) {
        int s = 0;
        if (MilvusServiceImpl.hasText((String)e.getDescripcionEstadoOrden())) {
            ++s;
        }
        if (MilvusServiceImpl.hasText((String)e.getEstadoOrdenEnvio())) {
            ++s;
        }
        if (MilvusServiceImpl.hasText((String)e.getNoFactura())) {
            ++s;
        }
        if (MilvusServiceImpl.hasText((String)e.getProveedorEnvio())) {
            ++s;
        }
        if (MilvusServiceImpl.hasText((String)e.getDescripcionEstadoEnvio())) {
            ++s;
        }
        if (MilvusServiceImpl.hasText((String)e.getNoGuiaEnvio())) {
            ++s;
        }
        if (MilvusServiceImpl.hasText((String)e.getDescripcionParcialGenerado())) {
            ++s;
        }
        if (MilvusServiceImpl.hasText((String)e.getFechaOrdenPedido())) {
            ++s;
        }
        if (MilvusServiceImpl.hasText((String)e.getFechaTrackingEnvio())) {
            ++s;
        }
        return s;
    }

    private static Integer parseIntSafe(String s) {
        try {
            return s == null ? null : Integer.valueOf(Integer.parseInt(s.trim()));
        }
        catch (Exception e) {
            return null;
        }
    }

    private String construirLineaProductos(String numeroPedido, HttpHeaders headers, ConcurrentMap<String, List<DetallePedidoProducto>> cacheDetalle) {
        List detalles = cacheDetalle.computeIfAbsent(numeroPedido, k -> this.consultarDetalleOrden(k, headers));
        if (detalles == null || detalles.isEmpty()) {
            return "N/A";
        }
        return detalles.stream().filter(Objects::nonNull).map(d -> {
            String descripcion = Optional.ofNullable(d.getDescripcionProducto()).map(s -> s.replaceAll("\\s+", " ").trim()).orElse("N/A");
            String cantidad = Optional.ofNullable(d.getCantidadOrdenPedidoDetalle()).map(Object::toString).orElse("0");
            return descripcion + " ,cant: " + cantidad;
        }).collect(Collectors.joining("; "));
    }

    private static boolean hasText(String s) {
        return s != null && !s.isBlank() && !"null".equalsIgnoreCase(s.trim());
    }

    private static String safe(String s) {
        return MilvusServiceImpl.hasText((String)s) ? s.trim() : "";
    }

    public String obtenerClientesConPedidos(String nombreColeccion) {
        this.milvusClient.loadCollection(LoadCollectionParam.newBuilder().withCollectionName(nombreColeccion).build());
        long batchSize = 1000L;
        long offset = 0L;
        LinkedHashMap<String, List> pedidosPorCliente = new LinkedHashMap<String, List>();
        while (true) {
            QueryParam query;
            R res;
            if ((res = this.milvusClient.query(query = QueryParam.newBuilder().withCollectionName(nombreColeccion).withExpr("id >= 0 && cliente != \"SIN_NOMBRE ID: N/A\" && cliente != \"\"").withOutFields(List.of("cliente", "texto")).withOffset(Long.valueOf(offset)).withLimit(Long.valueOf(1000L)).build())).getStatus().intValue() != R.Status.Success.getCode()) {
                throw new RuntimeException("Milvus query failed: " + res.getMessage());
            }
            List fields = ((QueryResults)res.getData()).getFieldsDataList();
            ProtocolStringList colCliente = List.of();
            ProtocolStringList colTexto = List.of();
            for (FieldData fd : fields) {
                if (!fd.hasScalars() || !fd.getScalars().hasStringData()) continue;
                switch (fd.getFieldName()) {
                    case "cliente": {
                        colCliente = fd.getScalars().getStringData().getDataList();
                        break;
                    }
                    case "texto": {
                        colTexto = fd.getScalars().getStringData().getDataList();
                    }
                }
            }
            if (colTexto.isEmpty()) break;
            for (int i = 0; i < colTexto.size(); ++i) {
                String cliente = i < colCliente.size() ? (String)colCliente.get(i) : "CLIENTE_DESCONOCIDO";
                String pedido = (String)colTexto.get(i);
                if (pedido == null || pedido.isBlank()) continue;
                pedidosPorCliente.computeIfAbsent(cliente, k -> new ArrayList()).add(pedido.trim());
            }
            if ((long)colTexto.size() < 1000L) break;
            offset += (long)colTexto.size();
        }
        List<Map> resultado = pedidosPorCliente.entrySet().stream().map(entry -> {
            LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
            obj.put("cliente", entry.getKey());
            obj.put("pedidos", entry.getValue());
            return obj;
        }).toList();
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(resultado);
        }
        catch (Exception e) {
            throw new RuntimeException("Error convirtiendo a JSON", e);
        }
    }

    private static boolean isNumeroOrdenValido(String s) {
        return MilvusServiceImpl.hasText((String)s) && !"0".equals(s.trim());
    }

    private static String onlyDigits(String s) {
        return s == null ? "" : s.replaceAll("\\D+", "");
    }

    private static String stripLeadingZeros(String s) {
        return s == null ? "" : s.replaceFirst("^0+(?!$)", "");
    }

    private Map<String, ClienteVendedor> buildClienteIndexByCodigo(List<ClienteVendedor> clientes) {
        ConcurrentHashMap<String, ClienteVendedor> idx = new ConcurrentHashMap<String, ClienteVendedor>();
        if (clientes == null) {
            return idx;
        }
        for (ClienteVendedor cv : clientes) {
            if (cv == null) continue;
            String raw = cv.getCodigo_cliente();
            String dig = MilvusServiceImpl.onlyDigits((String)raw);
            String no0 = MilvusServiceImpl.stripLeadingZeros((String)dig);
            if (raw != null && !raw.isBlank()) {
                idx.putIfAbsent(raw.trim(), cv);
            }
            if (!dig.isBlank()) {
                idx.putIfAbsent(dig, cv);
            }
            if (!no0.isBlank()) {
                idx.putIfAbsent(no0, cv);
            }
            if (dig.isBlank()) continue;
            idx.putIfAbsent("0" + dig, cv);
            idx.putIfAbsent("00" + dig, cv);
        }
        return idx;
    }

    private ClienteVendedor findClienteByCodigoPedido(String clienteOrdenPedido, Map<String, ClienteVendedor> idx) {
        if (clienteOrdenPedido == null || clienteOrdenPedido.isBlank() || idx == null || idx.isEmpty()) {
            return null;
        }
        String raw = clienteOrdenPedido.trim();
        String dig = MilvusServiceImpl.onlyDigits((String)raw);
        String no0 = MilvusServiceImpl.stripLeadingZeros((String)dig);
        ClienteVendedor cv = idx.get(raw);
        if (cv != null) {
            return cv;
        }
        cv = idx.get(dig);
        if (cv != null) {
            return cv;
        }
        cv = idx.get(no0);
        if (cv != null) {
            return cv;
        }
        cv = idx.get("0" + dig);
        if (cv != null) {
            return cv;
        }
        cv = idx.get("00" + dig);
        if (cv != null) {
            return cv;
        }
        for (Map.Entry<String, ClienteVendedor> e : idx.entrySet()) {
            String k = MilvusServiceImpl.onlyDigits((String)e.getKey());
            if (k.isEmpty() || !k.equals(dig) && !k.endsWith(dig) && !dig.endsWith(k) && !k.startsWith(dig) && !dig.startsWith(k)) continue;
            return e.getValue();
        }
        return null;
    }

    private List<String> listarColecciones() {
        ShowCollectionsResponse resp = (ShowCollectionsResponse)this.milvusClient.showCollections(ShowCollectionsParam.newBuilder().build()).getData();
        return resp.getCollectionNamesList();
    }

    public void resetAndRebuildGlobal() {
        List all = this.listarColecciones();
        ArrayList<CompletableFuture<Void>> drops = new ArrayList<CompletableFuture<Void>>();
        for (String c : all) {
            if (!this.esColeccionDeVendedor(c)) continue;
            drops.add(CompletableFuture.runAsync(() -> this.dropCollectionSafe(c), this.executorService));
        }
        CompletableFuture.allOf(drops.toArray(new CompletableFuture[0])).join();
        log.info("\ud83e\uddf9 Limpieza global completada.");
        this.subirTodosLosPedidosMilvus();
    }

    private boolean esColeccionDeVendedor(String name) {
        return name != null && name.matches("[a-z0-9_]+");
    }

    private void dropCollectionSafe(String collection) {
        try {
            boolean exists = (Boolean)this.milvusClient.hasCollection(HasCollectionParam.newBuilder().withCollectionName(collection).build()).getData();
            if (!exists) {
                log.info("Colecci\u00f3n no existe: {}", (Object)collection);
                return;
            }
            this.milvusClient.releaseCollection(ReleaseCollectionParam.newBuilder().withCollectionName(collection).build());
            try {
                this.milvusClient.dropIndex(DropIndexParam.newBuilder().withCollectionName(collection).build());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.milvusClient.dropCollection(DropCollectionParam.newBuilder().withCollectionName(collection).build());
            log.info("\u2705 Eliminada colecci\u00f3n {}", (Object)collection);
        }
        catch (Exception e) {
            log.error("\u274c Error eliminando {}: {}", (Object)collection, (Object)e.getMessage());
        }
    }

    private boolean esDeUltimos3Meses(String fechaOrdenPedido) {
        if (!MilvusServiceImpl.hasText((String)fechaOrdenPedido)) {
            return false;
        }
        try {
            LocalDateTime fechaPedido = LocalDateTime.parse(fechaOrdenPedido.replace(" ", ""));
            ZoneId zonaEcuador = ZoneId.of("America/Guayaquil");
            ZonedDateTime ahoraEcuador = ZonedDateTime.now(zonaEcuador);
            ZonedDateTime hace3Meses = ahoraEcuador.minusMonths(3L);
            ZonedDateTime fechaPedidoZoned = fechaPedido.atZone(zonaEcuador);
            return fechaPedidoZoned.isAfter(hace3Meses);
        }
        catch (Exception e) {
            return false;
        }
    }
}

